/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers;

import java.io.PrintStream;
import java.text.DecimalFormat;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

@DocumentedGATKFeature(groupName="Quality Control and Simple Analysis Tools", extraDocs={CommandLineGATK.class})
@Requires(value={DataSource.READS})
public class FlagStat
extends ReadWalker<Integer, Integer> {
    @Output
    PrintStream out;
    private FlagStatus myStat = new FlagStatus();

    @Override
    public Integer map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        ++this.myStat.readCount;
        if (read.getReadFailsVendorQualityCheckFlag()) {
            ++this.myStat.QC_failure;
        }
        if (read.getDuplicateReadFlag()) {
            ++this.myStat.duplicates;
        }
        if (!read.getReadUnmappedFlag()) {
            ++this.myStat.mapped;
        }
        if (read.getReadPairedFlag()) {
            ++this.myStat.paired_in_sequencing;
            if (read.getSecondOfPairFlag()) {
                ++this.myStat.read2;
            } else if (read.getReadPairedFlag()) {
                ++this.myStat.read1;
            }
            if (read.getProperPairFlag()) {
                ++this.myStat.properly_paired;
            }
            if (!read.getReadUnmappedFlag() && !read.getMateUnmappedFlag()) {
                ++this.myStat.with_itself_and_mate_mapped;
                if (!read.getReferenceIndex().equals(read.getMateReferenceIndex())) {
                    ++this.myStat.with_mate_mapped_to_a_different_chr;
                    if (read.getMappingQuality() >= 5) {
                        ++this.myStat.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5;
                    }
                }
            }
            if (!read.getReadUnmappedFlag() && read.getMateUnmappedFlag()) {
                ++this.myStat.singletons;
            }
        }
        return 1;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.out.println(this.myStat.toString());
    }

    static class FlagStatus {
        long readCount = 0L;
        long QC_failure = 0L;
        long duplicates = 0L;
        long mapped = 0L;
        long paired_in_sequencing = 0L;
        long read1 = 0L;
        long read2 = 0L;
        long properly_paired = 0L;
        long with_itself_and_mate_mapped = 0L;
        long singletons = 0L;
        long with_mate_mapped_to_a_different_chr = 0L;
        long with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5 = 0L;

        FlagStatus() {
        }

        public String toString() {
            String ret = "";
            StringBuilder builder = new StringBuilder(ret);
            DecimalFormat percentFormatter = new DecimalFormat("#0.00");
            builder.append(this.readCount);
            builder.append(" in total\n");
            builder.append(this.QC_failure);
            builder.append(" QC failure\n");
            builder.append(this.duplicates);
            builder.append(" duplicates\n");
            builder.append(this.mapped);
            builder.append(" mapped (");
            builder.append(percentFormatter.format((double)((float)this.mapped / (float)this.readCount) * 100.0));
            builder.append("%)\n");
            builder.append(this.paired_in_sequencing);
            builder.append(" paired in sequencing\n");
            builder.append(this.read1);
            builder.append(" read1\n");
            builder.append(this.read2);
            builder.append(" read2\n");
            builder.append(this.properly_paired);
            builder.append(" properly paired (");
            builder.append(percentFormatter.format((double)((float)this.properly_paired / (float)this.readCount) * 100.0));
            builder.append("%)\n");
            builder.append(this.with_itself_and_mate_mapped);
            builder.append(" with itself and mate mapped\n");
            builder.append(this.singletons);
            builder.append(" singletons (");
            builder.append(percentFormatter.format((double)((float)this.singletons / (float)this.readCount) * 100.0));
            builder.append("%)\n");
            builder.append(this.with_mate_mapped_to_a_different_chr);
            builder.append(" with mate mapped to a different chr\n");
            builder.append(this.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5);
            builder.append(" with mate mapped to a different chr (mapQ>=5)");
            return builder.toString();
        }
    }
}

