/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import java.util.Iterator;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.filters.ReadFilter;

public class BadCigarFilter
extends ReadFilter {
    @Override
    public boolean filterOut(SAMRecord rec) {
        Cigar c = rec.getCigar();
        if (c.isEmpty()) {
            return false;
        }
        Iterator<CigarElement> elementIterator = c.getCigarElements().iterator();
        CigarOperator firstOp = CigarOperator.H;
        while (elementIterator.hasNext() && (firstOp == CigarOperator.H || firstOp == CigarOperator.S)) {
            CigarOperator op = elementIterator.next().getOperator();
            if (firstOp != CigarOperator.H && op == CigarOperator.H) {
                return true;
            }
            firstOp = op;
        }
        if (firstOp == CigarOperator.D) {
            return true;
        }
        boolean hasMeaningfulElements = firstOp != CigarOperator.H && firstOp != CigarOperator.S;
        boolean previousElementWasIndel = firstOp == CigarOperator.I;
        CigarOperator lastOp = firstOp;
        CigarOperator previousOp = firstOp;
        while (elementIterator.hasNext()) {
            CigarOperator op = elementIterator.next().getOperator();
            if (op != CigarOperator.S && op != CigarOperator.H) {
                if (previousOp == CigarOperator.S || previousOp == CigarOperator.H) {
                    return true;
                }
                lastOp = op;
                if (!hasMeaningfulElements && op.consumesReadBases()) {
                    hasMeaningfulElements = true;
                }
                if (op == CigarOperator.I || op == CigarOperator.D) {
                    if (previousElementWasIndel) {
                        return true;
                    }
                    previousElementWasIndel = true;
                } else {
                    previousElementWasIndel = false;
                }
            } else if (op == CigarOperator.S && previousOp == CigarOperator.H) {
                return true;
            }
            previousOp = op;
        }
        return lastOp == CigarOperator.D || !hasMeaningfulElements;
    }
}

