/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.executive;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Future;

public class ReduceTree {
    private List<Queue<Future>> treeNodes = new ArrayList<Queue<Future>>();
    private boolean treeComplete = false;
    private TreeReduceNotifier treeReduceNotifier = null;

    public ReduceTree(TreeReduceNotifier notifier) {
        this.treeReduceNotifier = notifier;
    }

    public void addEntry(Future entry) {
        this.addNodeAtLevel(entry, 0);
    }

    public void complete() {
        this.treeComplete = true;
        this.reduce();
    }

    public Future getResult() {
        if (!this.treeComplete) {
            throw new IllegalStateException("Cannot get the final result for an incomplete tree.");
        }
        if (this.treeNodes.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.treeNodes.size() - 2; ++i) {
            if (this.treeNodes.get(i).size() <= 0) continue;
            throw new IllegalStateException("Some inner reduces were missed along the way.");
        }
        Queue<Future> lastLevel = this.treeNodes.get(this.treeNodes.size() - 1);
        if (lastLevel.size() != 1) {
            throw new IllegalStateException("Invalid number of entries at the tip of the tree: " + lastLevel.size());
        }
        return lastLevel.element();
    }

    protected void reduce() {
        this.reduce(0);
    }

    private void reduce(int level) {
        if (this.treeNodes.size() <= level) {
            return;
        }
        Queue<Future> treeLevel = this.treeNodes.get(level);
        while (treeLevel.size() >= 2) {
            this.addNodeAtLevel(this.treeReduceNotifier.notifyReduce(treeLevel.remove(), treeLevel.remove()), level + 1);
        }
        if (treeLevel.size() == 1 && this.treeComplete && !this.isDeepestLevel(level)) {
            Future element = treeLevel.remove();
            this.addNodeAtLevel(element, level + 1);
        }
        this.reduce(level + 1);
    }

    private boolean isDeepestLevel(int level) {
        return level == this.treeNodes.size() - 1;
    }

    protected void addNodeAtLevel(Future node, int level) {
        while (this.treeNodes.size() <= level) {
            this.treeNodes.add(new LinkedList());
        }
        this.treeNodes.get(level).add(node);
        this.reduce(level);
    }

    public static interface TreeReduceNotifier {
        public Future notifyReduce(Future var1, Future var2);
    }
}

