/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.rmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CloseableIterator;
import org.broadinstitute.sting.gatk.datasources.rmd.DataStreamSegment;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

abstract class ResourcePool<T, I extends CloseableIterator> {
    protected final SAMSequenceDictionary referenceSequenceDictionary;
    protected final GenomeLocParser genomeLocParser;
    private List<T> allResources = new ArrayList<T>();
    private List<T> availableResources = new ArrayList<T>();
    private Map<I, T> resourceAssignments = new HashMap<I, T>();

    protected ResourcePool(SAMSequenceDictionary referenceSequenceDictionary, GenomeLocParser genomeLocParser) {
        this.referenceSequenceDictionary = referenceSequenceDictionary;
        this.genomeLocParser = genomeLocParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I iterator(DataStreamSegment segment) {
        Object selectedResource = null;
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            selectedResource = this.selectBestExistingResource(segment, this.availableResources);
            if (selectedResource == null) {
                selectedResource = this.createNewResource();
                this.addNewResource(selectedResource);
            }
            this.availableResources.remove(selectedResource);
        }
        I iterator = this.createIteratorFromResource(segment, selectedResource);
        ResourcePool resourcePool2 = this;
        synchronized (resourcePool2) {
            this.resourceAssignments.put(iterator, selectedResource);
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(I iterator) {
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            T resource = this.resourceAssignments.get(iterator);
            T obj = this.resourceAssignments.remove(iterator);
            iterator.close();
            if (obj == null) {
                throw new ReviewedStingException("Failed to remove resource assignment; target key had no associated value in the resource assignment map");
            }
            if (!this.allResources.contains(resource)) {
                throw new ReviewedStingException("Iterator does not belong to the given pool.");
            }
            this.availableResources.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewResource(T resource) {
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            this.allResources.add(resource);
            this.availableResources.add(resource);
        }
    }

    protected abstract T createNewResource();

    protected abstract T selectBestExistingResource(DataStreamSegment var1, List<T> var2);

    protected abstract I createIteratorFromResource(DataStreamSegment var1, T var2);

    protected abstract void closeResource(T var1);

    int numIterators() {
        return this.allResources.size();
    }

    int numAvailableIterators() {
        return this.availableResources.size();
    }
}

