/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.CommandLineProgram;

public class PrintBGZFBounds
extends CommandLineProgram {
    @Argument(fullName="input", shortName="I", doc="Input bai file to process", required=true)
    private File input = null;
    private final int BYTE_SIZE_IN_BYTES = 1;
    private final int INT_SIZE_IN_BYTES = 4;
    private final int SHORT_SIZE_IN_BYTES = 2;
    private final int HEADER_SIZE = 18;
    private final int FOOTER_SIZE = 8;

    @Override
    public int execute() throws IOException {
        FileInputStream fis = new FileInputStream(this.input);
        ByteBuffer headerBuffer = this.allocateBuffer(18);
        ByteBuffer footerBuffer = this.allocateBuffer(8);
        float compressedSize = 0.0f;
        float uncompressedSize = 0.0f;
        long totalBlocks = 0L;
        while (true) {
            long blockStart = fis.getChannel().position();
            int totalRead = fis.getChannel().read(headerBuffer);
            if (totalRead <= 0) break;
            headerBuffer.flip();
            headerBuffer.position(headerBuffer.capacity() - 2);
            int cDataSize = headerBuffer.getShort() - 18 - 8 + 1;
            compressedSize += (float)cDataSize;
            fis.getChannel().position(fis.getChannel().position() + (long)cDataSize);
            fis.getChannel().read(footerBuffer);
            footerBuffer.flip();
            footerBuffer.position(footerBuffer.capacity() - 4);
            uncompressedSize += (float)footerBuffer.getInt();
            headerBuffer.flip();
            footerBuffer.flip();
            long blockStop = fis.getChannel().position() - 1L;
            System.out.printf("BGZF block %d: [%d-%d]%n", ++totalBlocks, blockStart, blockStop);
        }
        System.out.printf("SUCCESS!  Average compressed block size = %f, average uncompressed size = %f, compressed/uncompressed ratio: %f%n", Float.valueOf(compressedSize / (float)totalBlocks), Float.valueOf(uncompressedSize / (float)totalBlocks), Float.valueOf(compressedSize / uncompressedSize));
        return 0;
    }

    private ByteBuffer allocateBuffer(int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    public static void main(String[] argv) throws Exception {
        int returnCode = 0;
        try {
            PrintBGZFBounds instance = new PrintBGZFBounds();
            PrintBGZFBounds.start(instance, argv);
            returnCode = 0;
        }
        catch (Exception ex) {
            returnCode = 1;
            ex.printStackTrace();
            throw ex;
        }
        finally {
            System.exit(returnCode);
        }
    }
}

