/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.arguments;

import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class StandardCallerArgumentCollection {
    @Argument(fullName="heterozygosity", shortName="hets", doc="Heterozygosity value used to compute prior likelihoods for any locus", required=false)
    public Double heterozygosity = 0.001;
    @Argument(fullName="genotyping_mode", shortName="gt_mode", doc="Specifies how to determine the alternate alleles to use for genotyping", required=false)
    public GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE GenotypingMode = GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.DISCOVERY;
    @Argument(fullName="output_mode", shortName="out_mode", doc="Specifies which type of calls we should output", required=false)
    public UnifiedGenotyperEngine.OUTPUT_MODE OutputMode = UnifiedGenotyperEngine.OUTPUT_MODE.EMIT_VARIANTS_ONLY;
    @Argument(fullName="standard_min_confidence_threshold_for_calling", shortName="stand_call_conf", doc="The minimum phred-scaled confidence threshold at which variants should be called", required=false)
    public double STANDARD_CONFIDENCE_FOR_CALLING = 30.0;
    @Argument(fullName="standard_min_confidence_threshold_for_emitting", shortName="stand_emit_conf", doc="The minimum phred-scaled confidence threshold at which variants should be emitted (and filtered with LowQual if less than the calling threshold)", required=false)
    public double STANDARD_CONFIDENCE_FOR_EMITTING = 30.0;
    @Input(fullName="alleles", shortName="alleles", doc="The set of alleles at which to genotype when --genotyping_mode is GENOTYPE_GIVEN_ALLELES", required=false)
    public RodBinding<VariantContext> alleles;
    @Advanced
    @Argument(fullName="max_alternate_alleles", shortName="maxAltAlleles", doc="Maximum number of alternate alleles to genotype", required=false)
    public int MAX_ALTERNATE_ALLELES = 3;
}

