/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentMatches;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.EnumerationArgumentDefault;
import org.broadinstitute.sting.commandline.IntervalBindingArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.MissingArgumentValueException;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.commandline.RodBindingArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.commandline.UnknownEnumeratedValueException;
import org.broadinstitute.sting.utils.exceptions.DynamicClassResolutionException;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

class SimpleArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    private static Map<Class, Class> primitiveToWrapperMap = new HashMap<Class, Class>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Character.TYPE, Character.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
        }
    };

    SimpleArgumentTypeDescriptor() {
    }

    @Override
    public boolean supports(Class type) {
        if (RodBindingArgumentTypeDescriptor.isRodBinding(type) || IntervalBindingArgumentTypeDescriptor.isIntervalBinding(type)) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isEnum()) {
            return true;
        }
        if (primitiveToWrapperMap.containsValue(type)) {
            return true;
        }
        try {
            type.getConstructor(String.class);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type fulltype, ArgumentMatches matches) {
        void var8_18;
        Tags tags;
        block15: {
            int len$;
            T[] arr$;
            Object defaultEnumeration;
            String value;
            Class type;
            block16: {
                type = SimpleArgumentTypeDescriptor.makeRawTypeIfNecessary(fulltype);
                if (source.isFlag()) {
                    return true;
                }
                ArgumentDefinition defaultDefinition = this.createDefaultArgumentDefinition(source);
                value = this.getArgumentValue(defaultDefinition, matches);
                tags = this.getArgumentTags(matches);
                try {
                    if (type.isPrimitive()) {
                        Method valueOf = primitiveToWrapperMap.get(type).getMethod("valueOf", String.class);
                        if (value == null) {
                            throw new MissingArgumentValueException(this.createDefaultArgumentDefinition(source));
                        }
                        Object object = valueOf.invoke(null, value.trim());
                        break block15;
                    }
                    if (type.isEnum()) {
                        T[] vals = type.getEnumConstants();
                        defaultEnumeration = null;
                        arr$ = vals;
                        len$ = arr$.length;
                        break block16;
                    }
                    Constructor ctor = type.getConstructor(String.class);
                    Object t = ctor.newInstance(value);
                    break block15;
                }
                catch (UserException e) {
                    throw e;
                }
                catch (InvocationTargetException e) {
                    throw new UserException.CommandLineException(String.format("Failed to parse value %s for argument %s.  This is most commonly caused by providing an incorrect data type (e.g. a double when an int is required)", value, source.field.getName()));
                }
                catch (Exception e) {
                    throw new DynamicClassResolutionException(String.class, e);
                }
            }
            for (int i$ = 0; i$ < len$; ++i$) {
                Object val = arr$[i$];
                if (String.valueOf(val).equalsIgnoreCase(value)) {
                    return val;
                }
                try {
                    if (!type.getField(val.toString()).isAnnotationPresent(EnumerationArgumentDefault.class)) continue;
                    defaultEnumeration = val;
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new ReviewedStingException("parsing " + type.toString() + "doesn't contain the field " + val.toString());
                }
            }
            if (defaultEnumeration != null && value == null) {
                Object var8_16 = defaultEnumeration;
            } else {
                if (value == null) {
                    throw new MissingArgumentValueException(this.createDefaultArgumentDefinition(source));
                }
                throw new UnknownEnumeratedValueException(this.createDefaultArgumentDefinition(source), value);
            }
        }
        parsingEngine.addTags(var8_18, tags);
        return var8_18;
    }
}

