/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FTPReply {
    private static Logger log = Logger.getLogger(FTPReply.class);
    String reply;
    int code;

    public FTPReply(BufferedReader inputStream) throws IOException {
        String response = null;
        do {
            response = inputStream.readLine();
            log.debug("RESPONSE:" + response);
        } while (response != null && (!Character.isDigit(response.charAt(0)) || !Character.isDigit(response.charAt(1)) || !Character.isDigit(response.charAt(2)) || response.charAt(3) != ' '));
        if (response == null || response.length() < 3) {
            this.code = -1;
        } else {
            this.code = Integer.parseInt(response.substring(0, 3));
            this.reply = response.substring(3).trim();
        }
    }

    public int getCode() throws IOException {
        return this.code;
    }

    public String getReplyString() throws IOException {
        return this.reply;
    }

    public boolean isSuccess() {
        return this.isPositiveCompletion() || this.isPositiveIntermediate();
    }

    public boolean isPositiveCompletion() {
        return this.code >= 200 && this.code < 300;
    }

    public boolean isPositiveIntermediate() {
        return this.code >= 300 && this.code < 400;
    }
}

