/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.broad.tribble.util.ParsingUtils;
import org.broad.tribble.util.SeekableFTPStream;
import org.broad.tribble.util.SeekableFileStream;
import org.broad.tribble.util.SeekableHTTPStream;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.URLHelper;

public class SeekableStreamFactory {
    private static Logger log = Logger.getLogger(SeekableStreamFactory.class);

    public static SeekableStream getStreamFor(String path) throws IOException {
        if (path.startsWith("http:") || path.startsWith("https:")) {
            URL url = new URL(path);
            return SeekableStreamFactory.getHttpStream(url);
        }
        if (path.startsWith("ftp:")) {
            return new SeekableFTPStream(new URL(path));
        }
        return new SeekableFileStream(new File(path));
    }

    public static SeekableStream getHttpStream(URL url) {
        try {
            URLHelper helper = ParsingUtils.getURLHelper(url);
            return new SeekableHTTPStream(helper);
        }
        catch (Exception e) {
            log.error("Error creating URL helper: ", e);
            throw new RuntimeException("Error creating URL helper: " + e.toString());
        }
    }
}

