/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.IOException;
import java.util.Arrays;
import org.broad.tribble.util.SeekableStream;

public class SeekableBufferedStream
extends SeekableStream {
    private int bufferSize;
    private SeekableStream wrappedStream;
    private long position;
    long bufferPosition = Long.MIN_VALUE;
    byte[] buffer;

    public SeekableBufferedStream(SeekableStream wrappedStream) {
        this(wrappedStream, 512000);
    }

    public SeekableBufferedStream(SeekableStream wrappedStream, int bufferSize) {
        this.wrappedStream = wrappedStream;
        this.position = 0L;
        this.bufferSize = bufferSize;
        this.buffer = new byte[bufferSize];
    }

    @Override
    public long length() {
        return this.wrappedStream.length();
    }

    @Override
    public void seek(long position) throws IOException {
        this.position = position;
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public int read() throws IOException {
        if (this.position < this.bufferPosition || this.position >= this.bufferPosition + (long)this.buffer.length) {
            this.wrappedStream.seek(this.position);
            this.fill(this.buffer, 0, this.buffer.length);
            this.bufferPosition = this.position;
        }
        int idx = (int)(this.position - this.bufferPosition);
        ++this.position;
        int value = this.buffer[idx] & 0xFF;
        return value;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long bufferOffset;
        boolean noOverlap;
        int count = 0;
        long right = this.position + (long)len;
        long bufferRight = this.bufferPosition + (long)this.buffer.length;
        boolean bl = noOverlap = right <= this.bufferPosition || this.position >= bufferRight;
        if (this.bufferPosition < 0L || noOverlap) {
            this.wrappedStream.seek(this.position);
            this.fill(this.buffer, 0, this.buffer.length);
            this.bufferPosition = this.position;
        }
        if (this.position < this.bufferPosition) {
            int delta = (int)Math.min((long)len, this.bufferPosition - this.position);
            this.wrappedStream.seek(this.position);
            int n = this.fill(b, off, delta);
            this.position += (long)n;
            off += n;
            len -= (count += n);
        }
        if (len > 0 && (bufferOffset = this.position - this.bufferPosition) < (long)this.buffer.length) {
            int bo = (int)bufferOffset;
            int nBytes = this.buffer.length - bo;
            int delta = Math.min(len, nBytes);
            System.arraycopy(this.buffer, bo, b, off, delta);
            this.position += (long)delta;
            count += delta;
            off += delta;
            len -= delta;
        }
        if (len > 0) {
            this.wrappedStream.seek(this.position);
            int n = this.fill(b, off, len);
            count += n;
            this.position += (long)n;
        }
        return count;
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }

    @Override
    public boolean eof() throws IOException {
        return this.position >= this.wrappedStream.length();
    }

    public int fill(byte[] b, int offset, int len) throws IOException {
        int n;
        int count;
        for (n = 0; n < len; n += count) {
            count = this.wrappedStream.read(b, n + offset, len - n);
            if (count >= 0) continue;
            Arrays.fill(b, n, b.length - 1, (byte)0);
            return n;
        }
        return n;
    }
}

