/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.gelitext;

import java.util.Arrays;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.gelitext.DiploidGenotype;
import org.broad.tribble.gelitext.GeliTextFeature;

public class GeliTextCodec
extends AsciiFeatureCodec<GeliTextFeature> {
    private String[] parts;

    public GeliTextCodec() {
        super(GeliTextFeature.class);
    }

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    @Override
    public GeliTextFeature decode(String line) {
        try {
            if (line.startsWith("#") || line.startsWith("@")) {
                return null;
            }
            this.parts = line.trim().split("\\s+");
            if (this.parts.length != 18) {
                throw new CodecLineParsingException("Invalid GeliTextFeature row found -- incorrect element count.  Expected 18, got " + this.parts.length + " line = " + line);
            }
            char[] x = this.parts[5].toUpperCase().toCharArray();
            Arrays.sort(x);
            String bestGenotype = new String(x);
            double[] genotypeLikelihoods = new double[10];
            int pieceIndex = 8;
            int offset = 0;
            while (pieceIndex < 18) {
                genotypeLikelihoods[offset] = Double.valueOf(this.parts[pieceIndex]);
                ++pieceIndex;
                ++offset;
            }
            return new GeliTextFeature(this.parts[0], Long.valueOf(this.parts[1]), Character.toUpperCase(this.parts[2].charAt(0)), Integer.valueOf(this.parts[3]), Integer.valueOf(this.parts[4]), DiploidGenotype.toDiploidGenotype(bestGenotype), Double.valueOf(this.parts[6]), Double.valueOf(this.parts[7]), genotypeLikelihoods);
        }
        catch (CodecLineParsingException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to parse line " + line, e);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to parse line " + line, e);
        }
    }
}

