/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.bed;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.tribble.annotation.Strand;
import org.broad.tribble.bed.BEDFeature;
import org.broad.tribble.bed.SimpleBEDFeature;

public class FullBEDFeature
extends SimpleBEDFeature
implements BEDFeature {
    private static Logger log = Logger.getLogger(FullBEDFeature.class);
    private List<Exon> exons = new ArrayList<Exon>();

    public FullBEDFeature(String chr, int start, int end) {
        super(start, end, chr);
    }

    @Override
    public List<Exon> getExons() {
        return this.exons;
    }

    public void setExons(List<Exon> exons) {
        this.exons = exons;
    }

    public void addExon(Exon exon) {
        if (exon == null) {
            this.exons = new ArrayList<Exon>();
        }
        this.exons.add(exon);
    }

    public void addExon(int exonStart, int exonEnd, int cdStart, int cdEnd, int exonNumber) {
        Exon exon = new Exon(exonStart, exonEnd);
        exon.setCodingStart(cdStart);
        exon.setCodingEnd(cdEnd);
        exon.setNumber(exonNumber);
        this.addExon(exon);
    }

    public class Exon2 {
        private int number;
        private int readingFrame = -1;
        private int start;
        private int end;
        private int codingStart;
        private int codingEnd;
        boolean utr = false;
        private int mrnaBase = -1;

        public Exon2(int start, int end, int codingStart, int codingDne) {
            this.start = start;
            this.end = end;
            this.codingStart = codingStart;
            this.codingEnd = codingDne;
        }

        public void setMrnaBase(int base) {
            this.mrnaBase = base;
        }

        public int getAminoAcidNumber(int genomeCoordinate) {
            if (this.mrnaBase < 0) {
                return -1;
            }
            if (genomeCoordinate < FullBEDFeature.this.getStart() || genomeCoordinate > FullBEDFeature.this.getEnd()) {
                throw new IndexOutOfBoundsException();
            }
            if (FullBEDFeature.this.getStrand() == Strand.POSITIVE) {
                int mrnaCoord = this.mrnaBase + (genomeCoordinate - this.codingStart) - 1;
                return mrnaCoord < 0 ? -1 : mrnaCoord / 3 + 1;
            }
            if (FullBEDFeature.this.getStrand() == Strand.NEGATIVE) {
                int mrnaCoord = this.mrnaBase + (this.codingEnd - genomeCoordinate);
                return mrnaCoord < 0 ? -1 : mrnaCoord / 3 + 1;
            }
            return 0;
        }

        public void setUTR(boolean utr) {
            this.utr = utr;
            this.codingStart = FullBEDFeature.this.getStrand() == Strand.POSITIVE ? (this.codingEnd = FullBEDFeature.this.getEnd()) : (this.codingEnd = FullBEDFeature.this.getStart());
        }

        public void setCodingStart(int codingStart) {
            this.codingStart = Math.max(FullBEDFeature.this.getStart(), codingStart);
        }

        public void setCodingEnd(int codingEnd) {
            this.codingEnd = Math.min(FullBEDFeature.this.getEnd(), codingEnd);
        }

        public void setReadingFrame(int offset) {
            this.readingFrame = offset;
        }

        public void setPhase(int phase) {
            if (FullBEDFeature.this.getStrand() == Strand.POSITIVE) {
                this.readingFrame = phase;
            } else if (FullBEDFeature.this.getStrand() == Strand.NEGATIVE) {
                int modLen;
                this.readingFrame = modLen = (this.getCodingLength() - phase) % 3;
            }
        }

        public int getCdStart() {
            return this.codingStart;
        }

        public int getCdEnd() {
            return this.codingEnd;
        }

        public int getCodingLength() {
            return this.utr ? 0 : Math.max(0, this.codingEnd - this.codingStart);
        }

        int getReadingShift() {
            return this.readingFrame;
        }

        public String getValueString(double position) {
            String msg = this.number > 0 ? "Exon number: " + this.number : "";
            int aaNumber = this.getAminoAcidNumber((int)position);
            if (aaNumber > 0) {
                msg = msg + "<br>Amino acid number: " + aaNumber;
            }
            return msg;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }
    }

    public class Exon {
        int start;
        int end;
        private int number;
        private int readingFrame = -1;
        private int codingStart;
        private int codingEnd;
        boolean utr = false;
        private int mrnaBase = -1;

        public void setMrnaBase(int base) {
            this.mrnaBase = base;
        }

        public Exon(int start, int end) {
            this.start = start;
            this.end = end;
            this.codingStart = start;
            this.codingEnd = end;
        }

        public void setUTR(boolean utr) {
            this.utr = utr;
            this.codingStart = FullBEDFeature.this.strand == Strand.POSITIVE ? (this.codingEnd = this.end) : (this.codingEnd = this.start);
        }

        public void setCodingStart(int codingStart) {
            this.codingStart = Math.max(this.start, codingStart);
        }

        public void setCodingEnd(int codingEnd) {
            this.codingEnd = Math.min(this.end, codingEnd);
        }

        public void setReadingFrame(int offset) {
            this.readingFrame = offset;
        }

        public void setPhase(int phase) {
            if (FullBEDFeature.this.strand == Strand.POSITIVE) {
                this.readingFrame = phase;
            } else if (FullBEDFeature.this.strand == Strand.NEGATIVE) {
                int modLen;
                this.readingFrame = modLen = (this.getCodingLength() - phase) % 3;
            }
        }

        public int getCdStart() {
            return this.codingStart;
        }

        public int getCdEnd() {
            return this.codingEnd;
        }

        public int getCodingLength() {
            return this.utr ? 0 : Math.max(0, this.codingEnd - this.codingStart + 1);
        }

        int getReadingShift() {
            return this.readingFrame;
        }

        public String getValueString(double position) {
            String msg = this.number > 0 ? "Exon number: " + this.number : "";
            return msg;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }
    }
}

