/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.FormatInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormattingConverter<E>
extends Converter<E> {
    static final int INITIAL_BUF_SIZE = 256;
    static final int MAX_CAPACITY = 1024;
    FormatInfo formattingInfo;
    static final String[] SPACES = new String[]{" ", "  ", "    ", "        ", "                ", "                                "};

    public final FormatInfo getFormattingInfo() {
        return this.formattingInfo;
    }

    public final void setFormattingInfo(FormatInfo formattingInfo) {
        if (this.formattingInfo != null) {
            throw new IllegalStateException("FormattingInfo has been already set");
        }
        this.formattingInfo = formattingInfo;
    }

    @Override
    public final void write(StringBuffer buf, E event) {
        String s = this.convert(event);
        if (this.formattingInfo == null) {
            buf.append(s);
            return;
        }
        int min = this.formattingInfo.getMin();
        int max = this.formattingInfo.getMax();
        if (s == null) {
            if (0 < min) {
                FormattingConverter.spacePad(buf, min);
            }
            return;
        }
        int len = s.length();
        if (len > max) {
            if (this.formattingInfo.isLeftTruncate()) {
                buf.append(s.substring(len - max));
            } else {
                buf.append(s.substring(0, max));
            }
        } else if (len < min) {
            if (this.formattingInfo.isLeftPad()) {
                FormattingConverter.spacePad(buf, min - len);
                buf.append(s);
            } else {
                buf.append(s);
                FormattingConverter.spacePad(buf, min - len);
            }
        } else {
            buf.append(s);
        }
    }

    public static void spacePad(StringBuffer sbuf, int length) {
        while (length >= 32) {
            sbuf.append(SPACES[5]);
            length -= 32;
        }
        for (int i = 4; i >= 0; --i) {
            if ((length & 1 << i) == 0) continue;
            sbuf.append(SPACES[i]);
        }
    }
}

