#!@WHICHPERL@
##
## $Id: meme.pl 3919 2009-07-22 08:14:53Z tbailey $
##
## $Log:$
## $Rev: 3919 $ $Date: 2009-07-22 01:14:53 -0700 (Wed, 22 Jul 2009) $ $Author: tbailey $
## new meme form-submission file which integrates with opal
##
##

use lib qw(@PERLLIBDIR@);
use Globals;
use Validation;
use CGI qw/:standard/;          # use the CGI package
use SOAP::Lite;
use MIME::Base64;
use OpalServices;
use OpalTypes;
require "Utils.pm";

# get the directories using the new installation scheme
$dir = "@MEME_DIR@";		# installed directory
$logs = "$dir/LOGS";		# directory for temp files
$bin = "$dir/bin";		# directory for executables 
$service_url = "@OPAL@/MEME_@S_VERSION@";
$email_contact = '@contact@';
$short_dna_only = 1;            # only short sequence bfiles
$names_file = 'mast_db_names.csv';
$dbnames_url = "@SITE_URL@/cgi-bin/get_db_list.cgi?db_names=$names_file&short_only=$short_dna_only";
$db_doc_url = $dbnames_url . "&doc=1";

# defaults
$PROGRAM = "MEME";
$NERRORS = 0; 			# no errors yet

# get the parameters for the query
get_params();

# if there is no action specified, print an input form
if (! $action) {
  print_form() unless $NERRORS;
} else {
  check_params();
  submit() unless $NERRORS;
  print_tailers();
}

###############################################################################
####		SUBROUTINES:
###############################################################################

#
# print the form
#
sub print_form {

  my $action = "meme.cgi";
  my $logo = "../images/meme.png";
  my $alt = "$PROGRAM logo";
  my $form_description = qq {
Use this form to submit DNA or protein sequences to $PROGRAM. 
$PROGRAM will analyze your sequences for similarities among them and 
produce a description (<A HREF="../meme-intro.html"><B>motif</B></A>) 
for each pattern it discovers.
  }; # end quote

  #
  # required left side: address and sequences fields
  #
  my $seq_doc = "../help_sequences.html#sequences";
  my $alpha_doc = "../help_alphabet.html";
  my $format_doc = "../help_format.html";
  my $filename_doc = "../help_sequences.html#filename";
  my $paste_doc = "../help_sequences.html#actual-sequences";
  my $sample_file = "../examples/At.fa";
  my $sample_alphabet = "Protein";
  my $req_left = make_address_field($address, $address_verify);
  $req_left .= make_upload_sequences_field("datafile", "data", $MAXDATASET,
    $seq_doc, $alpha_doc, $format_doc, $filename_doc, $paste_doc, $sample_file,
    $sample_alphabet, $target);

  #
  # required right side
  #

  # make distribution buttons
  my $distr_doc = "../meme-input.html#distribution";
  my $distr = "How do you think the occurrences of a single motif are <A HREF='$distr_doc'><B>distributed</B></A> among the sequences?\n<BR>\n";
  my $checked = "zoops";
  my @values = (
    "<B>One per sequence</B>\n<BR>,oops", 
    "<B>Zero or one</B> per sequence\n<BR>,zoops",
    "<B>Any number</B> of repetitions\n<BR>,tcm"
  );
  my $req_right = make_radio_field($distr, "dist", $checked, @values);
  #$req_right .= "<B>Note:</B>The maximum number of occurrences of a motif is limited to 300."; 

  # make width fields
  $req_right .= qq {
<BR>
<!-- width fields -->
<BR>
$PROGRAM will find the optimum <A HREF="../help_width.html#motif_width"><B>width</B></A> 
of each motif within the limits you specify here: 
<BR>
<INPUT CLASS="maininput" TYPE="TEXT" SIZE=3 NAME="minw" VALUE=6>
<B>Minimum</B> width (>= 2) 
<BR>
<INPUT CLASS="maininput" TYPE="TEXT" SIZE=3 NAME="maxw" VALUE=50>
<B><A HREF="../help_width.html#max_width">Maximum</B></A> width (<= 300) 
<BR>
<BR>
<INPUT CLASS="maininput" TYPE="TEXT" SIZE=2 NAME="nmotifs" VALUE=3>
Maximum <A HREF="../meme-input.html#nmotifs"><B>number of motifs</B></A>
to find
  }; # end quote

  # finish required fields
  my $required = make_input_table("Required", $req_left, $req_right);

  #
  # optional fields
  #

  # optional left: description, nsites, shuffle fields 
  my $descr = "sequences";
  my $opt_left = make_description_field($descr, $description);

  # make nsites fields
  $opt_left .= qq {
<BR>
<!-- nsites fields -->
<BR>
$PROGRAM will find the optimum 
<A HREF="../meme-input.html#nsites"><B>number of sites</B></A>
for each motif within the limits you specify here: 
<BR>
<INPUT CLASS="maininput" TYPE="TEXT" SIZE=3 NAME="minsites" VALUE="">
<B>Minimum</B> sites (>= 2)
<BR>
<INPUT CLASS="maininput" TYPE="TEXT" SIZE=3 NAME="maxsites" VALUE="">
<B>Maximum</B> sites (<= 300)
<BR>
<BR>
  }; # end quote
  # shuffle checkbox
  my $doc = "../help_sequences.html#shuffle";
  my $text = "<A HREF='$doc'><B>Shuffle</B></A> sequence letters";
  $opt_left .= make_checkbox("shuffle", 1, $text, 0);

  # optional right fields: bfile, shuffle, dna-only: strand, pal

# FIXME: started to implement background model list
  #my $opt_right = "Background model for sequences--select <B>one</B> of the following:<BR>\n";
  #%my $opt_right .= make_supported_databases_field("bfile", $dbnames_url, $db_doc_url);
  $opt_right .= qq {
<BR>
Enter the name of a file containing a 
<A HREF="../meme-input.html#bfile"><B>background Markov model</B></A>:
<BR>
<INPUT CLASS="maininput" NAME="upload_bfile" TYPE="file">
  }; # end quote

  # DNA-ONLY options
  if (!defined $alphabet || $alphabet eq "ACGT") {
    my $doc = "../meme-input.html#posonly";
    my $text = "Search given <A HREF='$doc' <B>strand</B></A> only";
    my $options = make_checkbox("posonly", "1", $text, 0); 
    $options .= "<BR>\n";
    my $doc = "../meme-input.html#pal";
    my $text = "Look for <A HREF='$doc'><B>palindromes</B></A> only";
    $options .= make_checkbox("pal", "-pal", $text, 0); 
    $opt_right .= make_dna_only($options);
  } # dna options

  my $optional = make_input_table("Optional", $opt_left, $opt_right);
  
  # filtering options
  my $filter_purge = "";
  my $filter_dust = "";

  $filter_purge = qq {
<!-- purge fields -->
To use purge to remove similar sequences specify the maximum 
<A HREF="http://folk.uio.no/einarro/Presentations/blosum62.html"><B>blosum62
relatedness score</B></A> (100-200 recommended): 
<BR>
<INPUT CLASS="maininput" TYPE="TEXT" SIZE=3 NAME="purgescore" VALUE="">
<BR>
<BR>     
  }; # end quote

  $filter_dust = qq {
<!-- purge fields -->
To use <A HREF="http://www.liebertonline.com/doi/abs/10.1089/cmb.2006.13.1028"><B>dust</B></A>
to filter low complexity regions from your sequences set the cut-off
 (10-20 recommended): 
<BR>
<INPUT CLASS="maininput" TYPE="TEXT" SIZE=3 NAME="dustcutoff" VALUE="">
<BR>
<BR>     
  }; # end quote

  # add the dust and purge input area
  my $filters = make_input_table("Filters", $filter_purge, $filter_dust);
  

  #
  # print final form
  #
  my $form = make_submission_form(
    make_form_header($PROGRAM, "Submission form"),
    make_submission_form_top($action, $logo, $alt, $form_description),
    $required, 
    #$optional.$filters, 
    $optional, 
    make_submit_button("Start search", $email_contact),
    make_submission_form_bottom(),
    make_submission_form_tailer()
  );
  print "Content-Type: text/html\n\n$form";
  
} # print_form

# 
# get parameters from the input
# 
sub get_params {   

  # command options
  $options = "";   
  $dna_options = "";

  # retrieve the fields from the form
  $action = param('target_action');
  $address = param('address');
  $description = param('description');
  $datafile_name = param('datafile');
  $data = param('data');
  $dist = param('dist'); $options .= " -mod $dist" if $dist;
  $nmotifs = param('nmotifs'); $options .= " -nmotifs $nmotifs" if $nmotifs;
  $minsites = param('minsites'); $options .= " -minsites $minsites" if $minsites;
  $maxsites = param('maxsites'); $options .= " -maxsites $maxsites" if $maxsites;
  $minw = param('minw'); $options .=" -minw $minw" if $minw;
  $maxw = param('maxw'); $options .=" -maxw $maxw" if $maxw;
  @bfile = split(/,/, param('bfile'));
  $upload_bfile_name = param('upload_bfile'); 
$options .= " -bfile uploaded_bfile" if $upload_bfile_name; 
  $evt = param('evt'); $options .= " -evt $evt" if $evt;
  $shuffle = param('shuffle'); $shuffle = 0 unless ($shuffle);
  $pal = param('pal'); $dna_options .= " -pal" if $pal;
  $posonly = param('posonly'); $dna_options .= " -revcomp" unless $posonly;

  # extra options
  $options .= " -time $MAXTIME -maxsize $MAXDATASET";

  # filter options
  $purgeoptions = param('purgescore');
  $dustoptions = param('dustcutoff');

} # get_params

#
# Check the parameters on the form.
#
sub check_params {

  # change working directory to LOGS
  chdir($logs) || &whine("Can't cd to $logs");

  # check that valid email address was provided
  check_address($address, $email_contact);

  # check description field
  check_description($description);

  # get FASTA sequences and information about them
  ($fasta_data, $alphabet, $num, $min, $max, $ave, $total)
    = get_sequence_data($data, $datafile_name, $MAXDATASET, $shuffle, $purgeoptions,
       $dustoptions);
  $alphabet = lc($alphabet);

  # get the background model file
  if ($upload_bfile_name) {
    $bfile_data = "";
    while (<$upload_bfile_name>) {
      s/\r\n/\n/g;                                # Windows -> UNIX eol
      s/\r/\n/g;                                  # MacOS -> UNIX eol
      $bfile_data .= $_;
    }
    if (! $bfile_data) { 
      whine("The background file '$upload_bfile_name' is empty or non-existent."); 
    }
  }

#FIXME tlb; started to implement bfile menu
  # get the chosen background model name (from menu)
    #my $short_dna_only = 1;     #  short sequence dbs only
    #($db, $bfile_data, $db_alphabet, $target_alphabet, $db_root, $prot_db, $nuc_db, $short_seqs, $bfile_menu_name, $bfile_long_name, $bfile_descr) =
   #   get_db_name($alphabet, $upload_bfile_name, 0, $short_dna_only, @bfile);

  # check that TCM specified if only one sequence
  if (($num == 1) && !($dist eq "tcm")) {
    &whine("
      You must specify <I>Any number of repetitions</I> under the 
      <I>distribution</I> option
      since your dataset contains only one sequence.  Alternatively, you might 
      wish to break your sequence into several sequences.
    ");
  }

  # check that number of motifs is OK
  if ($nmotifs < 1 || $nmotifs > $MAXMOTIFS) {
    &whine("
       You must specify <I> number of motifs</I> between 1 and $MAXMOTIFS, inclusive.
    ");
  }

  # check that number of sites is OK
  &check_nsites($minsites, $maxsites, $dist, $num);

  # check that width is OK
  &check_width;

  # remove spaces, non-ASCII and single quotes from $datafile_name
  $datafile_name = "pasted sequences" unless($datafile_name); 
  $datafile_name =~ s/[ \'\x80-\xFF]/\_/g;

  # add dna options if alphabet permits
  $options .= $dna_options if ($alphabet eq "dna");

  # finish MEME argument list
  $args = "sequences -sf $datafile_name -$alphabet $options";
 
} # check_params

#
# check that number of sites is OK
#
sub check_nsites {
  my (
    $minsites, 			# minimum nsites
    $maxsites, 			# maximum nsites
    $dist, 			# type of distribution
    $num			# number of sequences
  ) = @_;

  if ($minsites && $minsites < $MINSITES) {
    whine("You must specify a minimum number of sites >= $MINSITES");
  }
  if ($maxsites && $maxsites > $MAXSITES) {
    whine("You must specify a maximum number of sites <= $MAXSITES");
  }
  if (($minsites && $maxsites) && $minsites > $maxsites) {
    whine(
     "The minimum number of sites is larger than the maximum number of sites");
  }
  # Make sure there aren't too many sequences in OOPS mode 
  # Note: MAXSITES and other globals are in lib/perl/Globals.pm
  if ($dist eq "oops" && $num > $MAXSITES) {
    &whine("
      Your dataset must contain no more than $MAXSITES sequences when you specify
      that the motif is <I>distributed</I> one per sequence.
      Please input a dataset with no more than $MAXSITES sequences or chose a
      different motif distribution.
    ");
  }
} # check_nsites

#
# check that width is OK
#
sub check_width {

  if ($minw < $MINW) {
    whine("The minimum width you specified ($minw) is too small.<BR>")
  }
  if ($maxw > $MAXW) {
    whine("The maximum width you specified ($maxw) is too large.<BR>")
  }
  if ($minw > $maxw) {
    whine("The minimum width you specified ($minw) is larger than the
	maximum width you specified ($maxw).<BR>")
  }
} # check_width


#
# make the verification message in HTML
#
sub make_verification {

  my $content = "<HR><UL>\n";

  $content .= "<LI> Description:<B> $description </B>\n" if $description;
  $content .= "<LI> Sequence file:<B> $datafile_name </B>\n";

  $content .= "<LI> Distribution of motif occurrences: <B>";
  if ($dist eq "oops") {
    $content .= "One per sequence</B>\n";
  } elsif ($dist eq "zoops") {
    $content .= "Zero or one per sequence</B>\n";
  } else {
    $content .= "Any number of repetitions</B>\n";
  }

  $content .= "<LI> Number of different motifs:<B> $nmotifs </B>\n" if $nmotifs;
  $content .= "<LI> Minimum number of sites:<B> $minsites </B>\n" if $minsites;
  $content .= "<LI> Maximum number of sites:<B> $maxsites </B>\n" if $maxsites;
  $content .= "<LI> Minimum motif width:<B> $minw </B>\n" if $minw;
  $content .= "<LI> Maximum motif width:<B> $maxw </B>\n" if $maxw;
  $content .= "<LI> Searching: <B>given strand only</B>\n" if $posonly;
  $content .= "<LI> Looking for: <B>palindromes only</B>\n" if $pal;
  $content .= "<LI> <B>Shuffling</B> letters in input sequences\n" if $shuffle;
  $content .= "<LI> Background model file: <B>$bfile_menu_name</B>\n" if $bfile_menu_name;
  $content .= "<LI> Background model file: <B>$upload_bfile_name</B>\n" if $upload_bfile_name;

  $content .= "
    <LI> Statistics on your dataset:
      <TABLE BORDER>
	<TR> <TD> type of sequence <TH ALIGN=RIGHT> $alphabet
	<TR> <TD> number of sequences <TH ALIGN=RIGHT> $num
	<TR> <TD> shortest sequence (residues) <TH ALIGN=RIGHT> $min
	<TR> <TD> longest sequence (residues) <TH ALIGN=RIGHT> $max
	<TR> <TD> average sequence length (residues) <TH ALIGN=RIGHT> $ave
	<TR> <TD> total dataset size (residues) <TH ALIGN=RIGHT> $total
      </TABLE>
    </UL>
  ";

  return($content);

} # make_verification

#
# Submit job to webservice via OPAL
#
sub submit
{
  $service = OpalServices->new(service_url => $service_url);

  #
  # start OPAL requst
  #
  $req = JobInputType->new();
  $req->setArgs($args);

  #
  # create list of OPAL file objects
  #
  @infilelist = ();
  # 1) Sequence file
  $inputfile = InputFileType->new("sequences", $fasta_data);
  push(@infilelist, $inputfile);
  # 2) Background file
  if ($upload_bfile_name) {
    $inputfile = InputFileType->new("uploaded_bfile", $bfile_data);
    push(@infilelist, $inputfile);
  }
  # 3) Email address file (for logging purposes only)
  $inputfile = InputFileType->new("address_file", $address);
  push(@infilelist, $inputfile);
  # 4) Submit time file (for logging purposes only)
  $inputfile = InputFileType->new("submit_time_file", `date -u '+%d/%m/%y %H:%M:%S'`);
  push(@infilelist, $inputfile);

  # Add file objects to request
  $req->setInputFile(@infilelist);

  # Submit the request to OPAL
  $result = $service->launchJob($req);

  # Give user the verification form and email message
  $verify = make_verification();
  verify_opal_job($result, $address, $email_contact, $verify);

} # submit
