#!@WHICHPERL@

use lib qw(@PERLLIBDIR@);
use Globals;
use Validation;
use CGI qw/:standard/;          # use the CGI package
use SOAP::Lite;
use MIME::Base64;
use OpalServices;
use OpalTypes;
require "Utils.pm";

# get the directories using the new installation scheme
$dir = "@MEME_DIR@";	# installed directory
$logs = "$dir/LOGS";	# directory for logs
$bin = "$dir/bin";	# binary directory
$service_url = "@OPAL@/GOMO_@S_VERSION@";	
$email_contact = '@contact@';
$names_file = "gomo_db.csv";
$dbnames_url = "@SITE_URL@/cgi-bin/get_db_list.cgi?db_names=$names_file&short_only=$short_dna_only";
$db_doc_url = $dbnames_url . "&doc=1";

# defaults
$PROGRAM = "GOMO";
$NERRORS = 0;				 # no errors yet
#$MAX_UPLOAD_SIZE = 1000000;

# get the parameters for the query
get_params();

# if there is no action specified, print an input form
if (! $action) {
  print_form() unless $NERRORS;
} else {
  check_params();
  submit() unless $NERRORS;
  print_tailers();
}

##############################
# SUBROUTINES 		     #
#############################

#
# print the input form
#
sub print_form {
  my $action = "gomo.cgi";
  my $logo = "../images/gomo.png";
  my $alt = "$PROGRAM logo";
  my $form_description = "Use this form to submit motifs to <B>$PROGRAM</B>. $PROGRAM will use the DNA binding motifs to find putative target genes and analyze their associated GO terms. A list of significant GO terms that can be linked to the given motifs will be produced. <a href=\"../gomo-intro.html\">Click here for more documentation.</a>";

  #
  # required section
  #

  # required left side: address, motifs
  my $motif_doc = "../doc/meme-format.html";
  my $motif_example = "../examples/sample-dna-motif.meme-io";
  my $example_type = "DNA minimal motif format file";
  my $inline_descr = "MEME motifs from sequences in file <TT>'$inline_name'</TT>.";
  my $req_left = make_address_field($address, $address_verify);
  $req_left .= "<BR>\n";
  $req_left .= make_motif_field($PROGRAM, "motifs", $inline_motifs, $alphabet, 
    $motif_doc, $motif_example, $inline_descr, $example_type);

  # required right side: database
  my $req_right = make_supported_databases_field("database", $dbnames_url, $db_doc_url);
 
  $req_right .= qq {
 	<BR>
        <BR>
        <B>Significance threshold</B>:<BR>
	<i>E</i>-value &le; <INPUT CLASS="maininput" TYPE="TEXT" SIZE="4" NAME="threshold" VALUE="10" />
	<BR>
	<BR>
  };# end quote
  my $score_function = "<A HREF='../gomo-intro.html'><B>Binding score function:</B></A><BR>";
  my $checked = "ama";
  my @values = (
    "<B>Average</B> binding affinity\n<BR>,avg-odds",
    "<B>Maximum</B> binding affinity\n<BR>,max-odds"
  );
  $req_right .= make_radio_field($score_function, "score_function", $checked, @values);

  #my $required = make_input_table("Required", $req_left, $req_right);
  my $required = make_input_table("", $req_left, $req_right);

  # 
  # optional arguments
  #

  # optional left: description
  my $descr = "motifs";
  my $opt_left = make_description_field($descr, $description);

  #
  # print final form
  #
  my $form = make_submission_form(
    make_form_header($PROGRAM, "Submission form"),
    make_submission_form_top($action, $logo, $alt, $form_description),
    $required,
    $optional, 
    make_submit_button("Start search", $email_contact),
    make_submission_form_bottom(),
    make_submission_form_tailer()
  );
  print "Content-Type: text/html \n\n$form";


} # print_form

#
# Make verification message in HTML
#
sub make_verification {

  my $content = "<HR>\n<UL>\n";

  $content .= "<LI> Description: <B>$description</B>\n" if $description;
  $content .= "<LI> Motif file name: <B>$motif_file_name</B>\n" if $motif_file_name;
  $content .= "<LI> Number of motifs: <B>$nmotifs</B>\n" if $nmotifs;
  $content .= "<LI> Total motif columns: <B>$total_cols</B>\n" if $total_cols;
  $content .= "<LI> Motif alphabet: <B>$motif_alphabet</B>\n" if $motif_alphabet;
  $content .= "<LI> Significance threshold:<B> $threshold </B>\n" if $threshold;
  $content .= "<LI> TF score function:<B> $score_function </B>\n" if $score_function;
  $content .= "<LI> Database to search: <B>$db_menu_name ($db)</B>\n" if $db_menu_name;
  $content .= "$db_descr\n" if $db_descr;
  $content .= "</UL>\n";

  return($content);

} # make_verification

#
# get parameters from the input
#
sub get_params {
  $options = '';		# global
  
  # retrieve the fields from the form
  $action = param('target_action');
  $address = param('address');
  $address_verify = param('address_verify');
  $description = param('description');
  $inline_motifs = param('inline_motifs');
  $inline_name = param('inline_name'); 
  #  $output_pthresh = param('output_pthresh');
  @database = split(/,/, param('database'));
  #  $upload_db_name = param('upload_db');
  $motif_file_name = $inline_motifs ? $inline_name : param('motifs'); 
  $threshold = param('threshold'); $options .=" --t $threshold" if $threshold;
  $score_function = param('score_function');

} # get_params

#
# check the user input
#
sub check_params {

  # set working directory to LOGS directory
  chdir($logs) || &whine("Can't cd to $logs");

  # check that valid email address was provided
  check_address($address);

  # check description field
  check_description($description);
  
  # check that threshold is OK
  &check_threshold;
  
  # create file containing motifs
  $motif_data = upload_motif_file($motif_file_name, $inline_motifs);

  # check motifs and get the alphabet
  ($motifs_found, $motif_alphabet, $nmotifs, $total_cols) = 
    check_meme_motifs("meme-io", $motif_data) if ($motif_data);

  # choose the appropriate database
  if ($motif_alphabet) {
    my $short_dna_only = 0;	# gomo scan long DNA
    ($db, $uploaded_data, $db_alphabet, $target_alphabet, $db_root, $prot_db, $nuc_db, $short_seqs, $db_menu_name, $db_long_name, $db_descr) =
      get_db_name($motif_alphabet, $upload_db_name, $translate_dna, $short_dna_only, @database);
  }


} # check_params

#
# check that threshold is OK
#
sub check_threshold {

  if ($threshold < 0) {
    whine("The threshold you specified ($threshold) is too small.<BR>")
  }
  if ($maxw > 100) {
    whine("The threshold you specified ($threshold) is too large.<BR>")
  }
} # check_threshold

#
# Submit job to OPAL
#
sub submit
{
  $gomo = OpalServices->new(service_url => $service_url);

  #
  # create the command
  #
  my $args = "motifs $db $score_function $options";

  #
  # start OPAL request
  #
  $req = JobInputType->new();
  $req->setArgs($args);
  
  #
  # create list of OPAL file objects
  #
  @infilelist = ();
  # 1) Motif File
  $inputfile = InputFileType->new("motifs", $motif_data);
  push(@infilelist, $inputfile);
  # 2) Uploaded sequence file
  if ($db_alphabet ne "local") {
    $inputfile = InputFileType->new($db, $uploaded_data);
    push(@infilelist, $inputfile);
  }
  # Email address file (for logging purposes only)
  $inputfile = InputFileType->new("address_file", $address);
  push(@infilelist, $inputfile);
  # Submit time file (for logging purposes only)
  $inputfile = InputFileType->new("submit_time_file", `date -u '+%d/%m/%y %H:%M:%S'`);
  push(@infilelist, $inputfile);

  # Add file objects to request
  $req->setInputFile(@infilelist);

  # Submit the request to OPAL
  $result = $gomo->launchJob($req);

  # Give user the verification form and email message
  my $verify = make_verification();
  verify_opal_job($result, $address, $email_contact, $verify);

} # submit

