#!@WHICHPERL@ -w

# This script copies the list of supported databases to
# the client. It is intended to support clients using 
# XMLHttpRequest to update a selection list of supported databases
# on a web page.

use lib qw(/home/tbailey/meme_svn/meme_4.1.0/INSTALLED/lib/perl);
require "Utils.pm";                     # must come before "whines"
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser set_message);

# Set standard message for error reporting.
set_message('Please report this message to <a href="mailto:@contact@">@contact@</mailto>.');

$csv_file = param('db_names');
$short_only = param('short_only');	# only include databases with "short_seqs"
					# field set to "yes"
$doc = param('doc');			# print documentation only if true
$is_motif_db = param('is_motif_db');

my $dir = "@MEME_DIR@";	# Installation directory
my $cgi = new CGI;

# Open list of supported databases.
my $result = open(DB_NAMES, "<$dir/etc/$csv_file"); 

# Print desired contents (names or documentation)
if (not $result) {
  print $cgi->header(-status=>'500 Internal Server Error');
  die "Unable to open the list of supported databases.\n";
} else {
  if ($doc) {
    doc_print();
  } else {
    list_print();
  }
  close(DB_NAMES);
}

#
# Output the list of databases
#
sub list_print {
  print "Content-type: text/plain\n\n";
  while (<DB_NAMES>) {
    next if (/^#/ || /^\s*$/);		# skip comments and whitespace
    my @fields = split /,/;
    # remove invisible whitespace from name and yes/no fields
    my $i;
    for ($i=0; $i<4; $i++) {
      $fields[$i] =~ s/\s+//g;
    }
    #next if ($short_only && $fields[3] eq 'no');
    $fields[2] = 'no' if ($short_only && $fields[3] eq 'no');	# turn off long DNA if need be
    # create a list of types and add to name if not a header
    if ($fields[0] =~ /\S/ && $fields[4] =~ /\S/) {
      my $db_types;
      if ($fields[1] eq 'yes' && $fields[2] eq 'yes') {
	$db_types = "peptide and nucleotide"; 
      } elsif ($fields[1] eq 'yes') {
	$db_types = "peptide only"; 
      } else {
	$db_types = "nucleotide only"; 
      }
      $fields[4] .= " ($db_types)";
    }
    print join ",", @fields;
  }
} # list_print 

#
# Output the documentation on supported databases.
# 
sub doc_print {
  # read in the file
  my @lines = <DB_NAMES>; 
 
  # get the number of separator lines
  my @categories = ();
  my @descriptions = ();
  for $_ (@lines) {
    next if (/^#/ || !/\S/);		# skip comments and blank lines
    my @fields = split(/,/);
    #next if ($short_only && $fields[3] eq 'no');	# skip categories with only long seqs
    $fields[2] = 'no' if ($short_only && $fields[3] eq 'no');	# turn off long DNA if need be
    if ($fields[0] !~ /\S/ && $fields[4] =~ /\S/) {
      $fields[4] =~ s/^-+//g; $fields[4] =~ s/-+$//g;
      push(@categories, $fields[4]);
      push(@descriptions, $fields[5]);
    }
  } 

  if ($is_motif_db) {
    $db_type1 = "Motif";
    $db_type2 = "motif";
  } else {
    $db_type1 = "Sequence";
    $db_type2 = "sequence";
  }
  my $form = "<html>\n";
  $form .= make_form_header("$db_type1 Databases", "Documentation");
  $form .= doc_start_body(\@categories, \@descriptions);
  $form .= doc_add_dbs(@lines);
  $form .= doc_finish_body();
  $form .= "</html>";

  print "Content-type: text/html\n\n$form";
} # doc_print

sub doc_start_body {
  my ($categories_p, $descriptions_p) = @_;

  # create list of categories
  my ($i, $cat_descr);
  my $ncats = @{$categories_p};
  for ($i=1; $i<=$ncats; $i++) {
    my $cat = $categories_p->[$i-1];
    my $descr = $descriptions_p->[$i-1];
    $cat_descr .= "<li><h3><a href=#cat$i>$cat</a></h3>\n";
    $cat_descr .= "  $descr\n";
  }

  my $content = qq %
   <body class="body">
    <table class="maintable">
      <tr>
        <td class="maintablewidth">
          <div id="main">
            <script src="../doc/meme-suite-logo.js" type="text/javascript"></script>
            <noscript>
              <h1>MEME Suite</h1>
              The MEME Suite web application requires the use of JavaScript
              <br />
              Javascript doesn't seem to be available on your browser.
            </noscript>
            <hr />
            <h1 align="center">$db_type1 databases available for search</h1>

            <hr />
            <h3>The $db_type2 databases that can be searched are grouped into
            $ncats categories:</h3>
            <ul> 
              $cat_descr
            </ul>
  %; 	# end of quote
} # doc_start_body

sub doc_add_dbs {
  my (@lines) = @_;

  my $i = 1;
  my $content;

  foreach $_ (@lines) {
    next if (/^#/ || !/\S/);		# skip comments and blank lines
    my @fields = split(/,/);
    $fields[2] = 'no' if ($short_only && $fields[3] eq 'no');	# remove DNA if need be
    if ($fields[0] !~ /\S/) {
      $fields[4] =~ s/^-+//g; $fields[4] =~ s/-+$//g;
      $content .= qq %
	    <a name="cat$i"></a>
	    <hr />
	    <h3>$fields[4]</h3>
	    <hr />
      % ; 		# end of quote
      $i++;
    } else {
      $content .= qq %
	    <dl>
	      <dt><b>$fields[4]</b></dt>
	      <dd>$fields[5]</dd>
        % ; 		# end of quote
      if ($is_motif_db) {
        $content .= qq %
              <dd></dd> 
            </dl>
        % ; 		# end of quote
      } else {
        my $db_types;
        if ($fields[1] eq 'yes' && $fields[2] eq 'yes') {
          $db_types = "peptide and nucleotide"; 
        } elsif ($fields[1] eq 'yes') {
          $db_types = "peptide only"; 
        } else {
          $db_types = "nucleotide only"; 
        }
	$content .= qq %
	      <dd>($db_types)</dd>
            </dl>
        % ; 		# end of quote
      }
    }
  }
  $content .= qq %
	    <hr />
    % ;		# end of quote

  return($content);
} # doc_add_dbs

sub doc_finish_body {
  my $content .= qq %
            <script src="../template-footer.js" type="text/javascript"></script>
          </div>
        </td>

      </tr>
    </table>
   </body>
    % ; # end of quote

  return($content);
} # doc_finish_body
