#include "config.h"
#include "beadstring-xml.h"
#include "projrel.h"
#include <unistd.h>

void print_beadstring_xml_header(FILE *out) {
  fputs("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n", out);
  fputs("<?xml-stylesheet type=\"text/xsl\" ", out);
  fprintf(out, "href=\"beadstring-to-html.xsl\"?>\n");
  fputs("<!-- Begin document body -->\n", out);
  fputs("<Beadstring\n", out);
  fputs("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", out);
  fputs("\n", out);
  fputs("  xsi:schemaLocation=", out);
  fputs("\"http://meme.sdsc.edu/schema/beadstring beadstring.xsd\"\n", out);
  fputs("  xmlns=\"http://meme.sdsc.edu/schema/beadstring\"\n", out);
  fputs("  xmlns:cis=\"http://zlab.bu.edu/schema/cisml\"\n", out);
  fputs("  xmlns:mem=\"http://noble.gs.washington.edu/meme\"\n", out);
  fprintf(out, "  version=\"%s\"\n  release=\"%s\"\n>\n", VERSION, ARCHIVE_DATE);
}

void print_beadstring_xml_alphabet(FILE *out , MHMM_T* hmm) {
  // Print alphabet
  char *alphabet_id = NULL;
  if (hmm->alph_size == NUM_BASES) {
    alphabet_id = "nucleotide";
  }
  else if (hmm->alph_size == NUM_AMINOS) {
    alphabet_id = "amino-acid";
  }
  else {
    alphabet_id = "unknown";
  }
  fprintf(out,
    "<alphabet id=\"%s\" length=\"%d\">\n",
    alphabet_id,
    hmm->alph_size
  );
  // Print alphabet
  int c, i;
  for (i = 0; i < hmm->alph_size; i++) {
    c = hmm->alphabet[i];
    fprintf(out, "<letter id=\"letter_%c\" symbol=\"%c\"/>\n", c, c);
  }
  fputs("</alphabet>",  out);
}

void print_beadstring_xml_model(FILE *out, OPTIONS_T* options, MHMM_T* hmm) {
  fputs("<model>\n", out);
  fputs("<command-line>\n", out);
  fprintf(out, "%s\n", options->command_line);
  fputs("</command-line>\n", out);
  // Look up host name
  const int MAX_HOST_NAME = 100;
  char hostname[MAX_HOST_NAME];
  int result = gethostname(hostname, MAX_HOST_NAME);
  if (result != 0) {
    snprintf(hostname, MAX_HOST_NAME, "CPU: unknown");
  }
  // Successful gethostname doesn't guarrantee null-termination.
  // Force null termination be safe.
  hostname[MAX_HOST_NAME  - 1] = 0;
  fputs("<host>", out);
  fprintf(out, "%s", hostname);
  fputs("</host>\n", out);
  fprintf(out, "<output-directory>%s</output-directory>\n", options->output_dirname);
  fprintf(out, "<meme-filename>%s</meme-filename>\n", options->meme_filename);
  if (options->model_filename) {
    fprintf(out, "<model-filename>%s</model-filename>\n", options->model_filename);
  }
  fprintf(out, "<seq-filename>%s</seq-filename>\n", options->seq_filename);
  if (options->bg_filename) {
    fprintf(out, "<bg-filename>%s</meme-filename>\n", options->bg_filename);
  }
  if (options->order_string) {
    fprintf(out, "<motif-order-string>%s</motif-order-string>\n", options->order_string);
  }
  fprintf(out, "<allow-weak-motfs>%s</allow-weak-motfs>\n", 
      options->allow_weak_motifs == TRUE ? "True" : "False");
  fprintf(out, "<allow-clobber>%s</allow-clobber>\n", 
      options->allow_clobber == TRUE ? "True" : "False");
  fprintf(out, "<fim>%s</fim>\n", options->fim == TRUE ? "True" : "False");
  fprintf(out, "<local-scoring>%s</local-scoring>\n", 
    options->local_scoring == TRUE ? "True" : "False");
  fprintf(out, "<motif-scoring>%s</motif-scoring>\n", 
    options->motif_scoring == TRUE ? "True" : "False");
  fprintf(out, "<perform-search>%s</perform-search>\n", 
    options->perform_search == TRUE ? "True" : "False");
  fprintf(out, "<synth>%s</synth>\n", options->synth == TRUE ? "True" : "False");
  fprintf(out, "<zselo>%s</zselo>\n", options->zselo == TRUE ? "True" : "False");
  fprintf(out, "<max-seq>%d</max-seq>\n", options->max_seq);
  fprintf(out, "<pam-distance>%d</pam-distance>\n", options->pam_distance);
  fprintf(out, "<paths>%d</paths>\n", options->paths);
  fprintf(out, "<spacer-states>%d</spacer-states>\n", options->spacer_states);

  fputs("</model>\n", out);
}

void print_beadstring_xml_cisml(FILE *out, MHMM_T* hmm, CISML_T* cisml) {
}

void print_beadstring_xml_trailer(FILE *out) {
  fputs("</Beadstring>\n", out);
}
