/**********************************************************************
 * FILE: ama_scan.h
 * AUTHOR: Fabian Buske / Robert McLeay for refactoring
 * PROJECT: MEME
 * COPYRIGHT: 2007-2008, UQ
 * VERSION: $Revision: 1.0$
 * DESCRIPTION: Routines to perform average motif affinity scans
 *
 **********************************************************************/

#ifndef AMA_SCAN_H_
#define AMA_SCAN_H_

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "meme-io.h"
#include "string-list.h"
#include "macros.h"
#include "motif.h"
#include "matrix.h"
#include "array.h"
#include "pssm.h"
#include "seq.h"
#include "alphabet.h"
#include "cisml.h"
#include "zscore.h"

extern char* motif_name; // Use this motif name in the output.

extern VERBOSE_T verbosity;

#define AVG_ODDS 0
#define MAX_ODDS 1

#define min(a,b)      (a<b)?a:b
#define max(a,b)      (a>b)?a:b

/**********************************************************************
  ama_sequence_scan(
 **********************************************************************/
void ama_sequence_scan(
  SEQ_T* sequence,              // the sequence to scan (IN)  
  PSSM_PAIR_T* pssm_pair,       // the pos/neg pssms (IN)  
  int scoring,                  // AVG_ODDS or MAX_ODDS (IN)
  int zscoring,                 // the number of shuffled sequences
                                // used for z-score computation (IN)  
  SCANNED_SEQUENCE_T* scanned_seq // the scanned sequence results (OUT)
); 
#endif /* AMA_SCAN_H_ */
