/* init.c */
/* init.c: Perform initialization of the main symbol-table. i.e.
   install builtin functions, predefined variables etc. */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992, 1993, 1994  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#include "rlab.h"
#include "symbol.h"
#include "bltin.h"
#include "util.h"
#include "scalar.h"

#include <stdio.h>

#ifdef HAVE_RLAB_PLPLOT
#include "r_plot.h"
#endif

#ifdef THINK_C
/* Mac lib confliction */
#define Open Openx
#endif

/* trig.c */
extern void Atan2 _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Sin _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Asin _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Cos _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Acos _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Tan _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Atan _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

/* math_1.c */
extern void Abs _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Mod _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Log _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Log10 _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Exp _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Sqrt _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Int _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Ceil _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Floor _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Round _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Inv _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Solve _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Lu _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

/* math_2.c */
extern void Rcond _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Det _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Svd _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Eig _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Norm _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Chol _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void QR _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Hess _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Max _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void MaxI _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Min _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void MinI _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Sort _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Balance _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

/* math_3.c */
extern void Real _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Imag _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Conj _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void FFT _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void IFFT _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Sum _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Prod _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Factor _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Backsub _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Schur _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Sylv _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Issymm _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void EigS _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void EigN _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void SchOrd _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Filter _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

/* print.c */
extern void Printf _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void FPrintf _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void SPrintf _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Close _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Open _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

/* random.c */
extern void Rand _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void SRand _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

/* getline.c */
extern void Getline _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Strsplt _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

/* bi_io.c */
extern void WriteB _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void ReadB  _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void GetB   _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Fread  _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Fseek  _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

/* odei.c */
extern void odei _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

Bltin rlab_bltin[] =
{
  {BLTIN, "max", Max},
  {BLTIN, "sign", Sign},
  {BLTIN, "error", Error},
  {BLTIN, "cd", CD},
  {BLTIN, "any", Any},
  {BLTIN, "abs", Abs},
  {BLTIN, "acos", Acos},
  {BLTIN, "all", All},
  {BLTIN, "atan", Atan},
  {BLTIN, "asin", Asin},
  {BLTIN, "atan2", Atan2},
  {BLTIN, "balance", Balance},
  {BLTIN, "close", Close},
  {BLTIN, "open", Open},
  {BLTIN, "chol", Chol},
  {BLTIN, "ceil", Ceil},
  {BLTIN, "class", Class},
  {BLTIN, "clear", Clear},
  {BLTIN, "cos", Cos},
  {BLTIN, "conj", Conj},
  {BLTIN, "det", Det},
  {BLTIN, "diary", Diary},
  {BLTIN, "eig", Eig},
  {BLTIN, "eigs", EigS},
  {BLTIN, "eign", EigN},
  {BLTIN, "ifft", IFFT},
  {BLTIN, "floor", Floor},
  {BLTIN, "exp", Exp},
  {BLTIN, "fft", FFT},
  {BLTIN, "find", Find},
  {BLTIN, "fprintf", FPrintf},
  {BLTIN, "format", Format},
  {BLTIN, "getline", Getline},
  {BLTIN, "hess", Hess},
#ifdef THINK_C
  {BLTIN, "length", Lengthx},
#else
  {BLTIN, "length", Length},
#endif
  {BLTIN, "inf", Inf},
  {BLTIN, "imag", Imag},
  {BLTIN, "int", Int},
  {BLTIN, "inv", Inv},
  {BLTIN, "log", Log},
  {BLTIN, "load", Load},
  {BLTIN, "log10", Log10},
  {BLTIN, "matrix", Matrix_cast},
  {BLTIN, "show", Show},
  {BLTIN, "printf", Printf},
  {BLTIN, "mini", MinI},
  {BLTIN, "maxi", MaxI},
  {BLTIN, "members", Members},
  {BLTIN, "min", Min},
  {BLTIN, "mod", Mod},
  {BLTIN, "nan", Nan},
  {BLTIN, "norm", Norm},
  {BLTIN, "read", Read},
  {BLTIN, "qr", QR},
  {BLTIN, "prod", Prod},
  {BLTIN, "rand", Rand},
  {BLTIN, "rcond", Rcond},
  {BLTIN, "real", Real},
  {BLTIN, "readm", ReadM},
  {BLTIN, "reshape", Reshape},
  {BLTIN, "round", Round},
  {BLTIN, "scalar", Scalar_cast},
  {BLTIN, "svd", Svd},
  {BLTIN, "sort", Sort},
  {BLTIN, "sin", Sin},
  {BLTIN, "size", Size},
  {BLTIN, "solve", Solve},
  {BLTIN, "sqrt", Sqrt},
  {BLTIN, "sprintf", SPrintf},
  {BLTIN, "srand", SRand},
  {BLTIN, "strsplt", Strsplt},
  {BLTIN, "sum", Sum},
  {BLTIN, "type", Type},
  {BLTIN, "sizeof", Sizeof},
  {BLTIN, "tan", Tan},
  {BLTIN, "system", System},
  {BLTIN, "tic", Tic},
  {BLTIN, "toc", Toc},
  {BLTIN, "write", Write},
  {BLTIN, "what", What},
  {BLTIN, "who", Who},
  {BLTIN, "writem", WriteM},
  {BLTIN, "zeros", Zero},
  {BLTIN, "exist", Exist},
  {BLTIN, "strtod", Strtod},
  {BLTIN, "ones", rOnes},
  {BLTIN, "diag", Diag},
  {BLTIN, "factor", Factor},
  {BLTIN, "backsub", Backsub},
  {BLTIN, "schur", Schur},
  {BLTIN, "schord", SchOrd},
  {BLTIN, "filter", Filter},
  {BLTIN, "sylv", Sylv},
  {BLTIN, "issymm", Issymm},
  {BLTIN, "fvscope", FVScope},
  {BLTIN, "writeb", WriteB},
  {BLTIN, "readb", ReadB},
  {BLTIN, "getb", GetB},
  {BLTIN, "fread", Fread},
  {BLTIN, "fseek", Fseek},
  {BLTIN, "ode", odei},
  {BLTIN, "getenv", Getenv},
  {BLTIN, "tmpnam", Tmpnam},
  {BLTIN, "eval", Eval},
  {BLTIN, "_garbage", Garbage},
#ifdef HAVE_RLAB_PLPLOT
  {BLTIN, "plprint", _plot_plprint},
  {BLTIN, "_replot", _plot_plreplot},
  {BLTIN, "_plsstrm", _plot_plsstrm},
  {BLTIN, "_plssub", _plot_plssub},
  {BLTIN, "_plinit", _plot_plinit},
  {BLTIN, "_plstart", _plot_plstart},
  {BLTIN, "_plenv", _plot_plenv},
  {BLTIN, "_plline", _plot_plline},
  {BLTIN, "_plend", _plot_plend},
  {BLTIN, "_plend1", _plot_plend1},
  {BLTIN, "_pllab", _plot_pllab},
  {BLTIN, "_plcol", _plot_plcol},
  {BLTIN, "_plscolbg", _plot_plscolbg},
  {BLTIN, "_plscol0", _plot_plscol0},
  {BLTIN, "_pllsty", _plot_pllsty},
  {BLTIN, "_plclr", _plot_plclr},
  {BLTIN, "_plpoin", _plot_plpoin},
  {BLTIN, "_plhist", _plot_plhist},
  {BLTIN, "_plspage", _plot_plspage},
  {BLTIN, "_pladv", _plot_pladv},
  {BLTIN, "_plgra", _plot_plgra},
  {BLTIN, "_pltext", _plot_pltext},
  {BLTIN, "_plflush", _plot_plflush},
  {BLTIN, "_plbox", _plot_plbox},
  {BLTIN, "_plbox3", _plot_plbox3},
  {BLTIN, "_plvsta", _plot_plvsta},
  {BLTIN, "_plwind", _plot_plwind},
  {BLTIN, "_plot3d", _plot_plot3d},
  {BLTIN, "_plmesh", _plot_plmesh},
  {BLTIN, "_plw3d", _plot_plw3d},
  {BLTIN, "_plmtex", _plot_plmtex},
  {BLTIN, "_plspause", _plot_plspause},
  {BLTIN, "_plwid", _plot_plwid},
  {BLTIN, "_plptex", _plot_plptex},
  {BLTIN, "_plfontld", _plot_plfontld},
  {BLTIN, "_plfont", _plot_plfont},
  {BLTIN, "_plsori", _plot_plsori},
  {BLTIN, "_plscolor", _plot_plscolor},
  {BLTIN, "_plcont", _plot_plcont},
  {BLTIN, "_plvpor", _plot_plvpor},
  {BLTIN, "_plerry", _plot_plerry},
#endif  /* HAVE_RLAB_PLPLOT */
  {0, 0, 0},
};

/* **************************************************************
 * Install built-ins in symbol table.
 * ************************************************************** */
void
init_symbol_table ()
{
  int i;
  char *name;

  symbol_table_create ();	/* Create RLaB global symbol table */

  /* load all RLaB built-in functions */
  for (i = 0; rlab_bltin[i].name; i++)
  {
    name = cpstr (rlab_bltin[i].name);
    install (0, name, rlab_bltin[i].type, &rlab_bltin[i]);
  }
}
