#
# Test 2-D plots
#

pstart ();
x = (0.25:4:.25)';

ptitle ("Multiple Line Colors and Styles");
xlabel ("X-axis Label");
ylabel ("Y-axis Label");
plot ( [x, x, 2*x, 3*x] );
pause ("Type RETURN to continue");

ptitle ("Multiple Point Colors and Styles");
plstyle ("point");
plot ( [x, x, 2*x, 3*x] );
pause ("Type RETURN to continue");

# Start a new window with multiple plots
pstart(2,2);

# Show off Grid Styles
ptitle("Plot 1, No Grid");
plgrid ("", "");
plot ([x,exp(-x*0.5)]);

ptitle("Plot 2, Grid Box Only");
plgrid ("bc", "bcv");
plot ([x,2*x,3*x,4*x]);

ptitle("Plot 3, Box, and Coordinates");
plgrid ("bcnt", "bcnvt");
plot ([x,-2*x,2*x]);

ptitle("Plot 4, ");
plgrid ("bcngst", "bcngvst");
plot ([x,x,cos(2*pi*x*0.25)]);
pause ("Type RETURN to continue");

# Show off axis types
ptitle("Linear Axes");
plgrid();
plot ([x,exp(-x*0.5)]);

ptitle("Log X - Axis");
plgrid("bcngstl");
plot ([x,exp(-x*0.5)]);

ptitle("Log Y - Axis");
plgrid("bcngst", "bcngstlv");
plot ([x,exp(-x*0.5)]);

ptitle("Log  Axes");
plgrid("bcngstl", "bcngstlv");
plot ([x,exp(-x*0.5)]);
pause ("Type RETURN to continue");

pstart();

# Data with different scales
y = (0.5:6:.2)';
ptitle("Plot Data with Different Scales");
plot (<< [x,exp(-x*0.5)] ; [y, exp (y*0.25), exp(y*0.1)] >>);
pause ("Type RETURN to continue");

# Histograms

rand("normal", 0, pi);
r = rand(2000,1);

ptitle("Histogram, Default No. of Bins");
plhist (r);
pause ("Type RETURN to continue");

ptitle("Histogram, 30 Bins");
plhist (r, 30);
pause ("Type RETURN to continue");

# Make 3D data

# Sombrero

NX = 20;
NY = 20;
xx = zeros (1, NX);
yy = zeros (1, NY);
for (i in 1:NX) { xx[i] = (i - NX/2)/(NX/2); }
for (i in 1:NY) { yy[i] = (i - NY/2)/(NY/2); }

zz = zeros (NX, NY);

for (i in 1:NX)
{
  for (j in 1:NY)
  {
    r = sqrt (xx[i]^2 + yy[j]^2);
    zz[i;j] = exp (-r * r) * cos (2*pi*r);
  }
}

# Now create some plots

ptitle("3-D Plot, Sombrero");
plmesh (<< x = xx; y = yy; z = zz>>);
pause ("Type RETURN to continue");

# Sin - Cos surface

x1 = -3:3:.2;
y1 = -3:3:.2;
z1 = zeros (x1.n, y1.n);

for (i in 1:x1.n)
{
  for(j in 1:y1.n)
  {
    z1[i;j] = sin(y1[j]) * cos(x1[i]);
  }
}

ptitle("3-D Plot, Cos-Sine Surface");
plmesh (<< x = x1; y = y1; z = z1>>);
pause ("Type RETURN to continue");

# Slanted plane

x2 = 1:10;
y2 = 1:10;
z2 = zeros (x2.n, y2.n);
for (i in 1:x2.n) { z2[i;] = i*ones(1,y2.n); }
 
ptitle("3-D Plot, Plane");
plmesh (<< x = x2; y = y2; z = z2>>);
pause ("Type RETURN to continue");

# Two Slanted planes
z3 = -2*z2;
ptitle("3-D Plot, 2 - Planes");
plmesh (<< x = x2; y = y2; z = z2>>, <<x = x2; y = y2; z = z3 >>);

# Exponential Surface (sort-of)

x4 = -2:2:.2;
y4 = x4;
z4 = [];
for (i in 1:x4.n) { 
  for (j in 1:y4.n) { 
    z4[i;j] = x4[i] * exp (-x4[i]^2 - y4[j]^2);
  }
}
ptitle ("Neat Surface");
plmesh (<<x=x4;y=y4;z=z4>>);

# Now show 3-D viewing angles

# Switch back to 2-by-2 window
pwin(1);
"Focus on 2nd window"
pause ("Type RETURN to continue");

ptitle("3-D Plot, Sombrero, Default View, Alt = 60, Az = 45");
plmesh (<< x = xx; y = yy; z = zz>>);

ptitle("3-D Plot, Sombrero, Alt = 10, Az = 10");
plalt(10); 
plaz(10);
plmesh (<< x = xx; y = yy; z = zz>>);

ptitle("3-D Plot, Sombrero, Alt = 20, Az = 30");
plalt(20); 
plaz(30);
plmesh (<< x = xx; y = yy; z = zz>>);

ptitle("3-D Plot, Sombrero, Alt = 80, Az = 60");
plalt(80); 
plaz(60);
plmesh (<< x = xx; y = yy; z = zz>>);

ans = input ("Replot (y/n) ?:", "s");
if (ans == "y" || ans == "Y") { replot(); }

pause ("Type RETURN to END");

pend();
