/* bltin.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992, 1994  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef RLAB_BLTIN
#define RLAB_BLTIN

#include "rlab.h"
#include "code.h"
#include "list.h"

#ifdef THINK_C
/* conflict with Mac library */
#define Size Sizex
#endif

struct _bltin
{
  int type;
  char *name;
  void (*func) ();
};

typedef struct _bltin Bltin;

extern Datum get_bltin_arg _PROTO ((char *bltin_name, Datum * arg_array,
				    int arg_number, int type));

extern void Load _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Zero _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void rOnes _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Diag _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Size _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

#ifdef THINK_C
extern void Lengthx _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
#else
extern void Length  _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
#endif

extern void What _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Who _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Members _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Class _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Write _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Reshape _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Read _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Show _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Format _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Diary _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Error _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void ReadM _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void WriteM _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Any _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void All _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Clear _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void CD _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Exist _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Strtod _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

extern void System _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Scalar_cast _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Matrix_cast _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Type _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Sizeof _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

extern void Garbage _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Tic _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Toc _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Find _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

extern void Inf _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Nan _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

extern void FVScope _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Getenv  _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Tmpnam  _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));
extern void Eval    _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

extern void Sign    _PROTO ((VPTR * return_ent, int n_args, Datum * d_arg));

#define bltin_GetFuncPtr(a)    (a)->func;

#endif /* RLAB_BLTIN */
