
#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"
#include "xtools/vfp/windesign.h"
#include "xtools/vfp/message.h"
#include "xtools/baseclr.h"

static char *states[] = {"-- Waiting for Message","-- Sending Message",
		    "-- Receiving Message", "-- Processing" }  ;


int* VFPMakeRoute( ) ;
int VFPSetMsgColor( ) ; 

/*****
  SIZE indicates the number of different shades that will be used
  to indicate message size.  Should not be a defined value.
*****/


#define SIZE  10 
#define WAIT 0
#define SEND 1
#define REC  2
#define WORK 3


/*****
  These stipple were just but here to give something to use.
  They are probably not actually good enough to be used
*****/
char grey[] = {
   0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55};
char ltgrey[] = {
   0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55};
char white[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
char black[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};


int main( argc, argv )
  int    argc ; 
  char **argv ;
{
  unsigned int  width,
                height ;
  int           px, py;
  XBWindow      *XBWin ;
  XBFont        font ;
  VFPInfo       *info ;
  XB3DBoxStruct *Box1,
                *Box2 ; 
  Pixmap        pix1,
                pix2 ;         
  PixVal        pixval1,
                pixval2 ;

  XBTextBoxStruct *text_info ;

  width = 500 ;
  height = 600 ;
  px     = -1;
  py     = -1;
  XBWin  = XBWinCreate();
  XBGetArgs( &argc, argv, 1, &px, &py, &width, &height );
  if (XBOpenDisplay( XBWin, "" )) {
      fprintf( stderr, "***Could not open display***\n" );
      return 1;
      }
  if (XBSetVisual( XBWin, 1, 0 )) 
    fprintf( stderr, "***Could not set visual to default***\n" );
/*
  XBWin->cmap = (Colormap)0 ;
  XBInitColors( XBWin ) ;
*/
  if (XBOpenWindow( XBWin )) 
    fprintf( stderr, "***Could not open the window***\n" );
  if (XBDisplayWindow( XBWin, "Message Display", px, py, width, height, 0 )) 
    fprintf( stderr, "***Could not display window***\n" );
  XBSetGC( XBWin, XBWin->cmapping[1] );

  XBInitFonts( XBWin ) ;
  XBMatchFontSize( &font, 9, 15 ) ;
  XBLoadFont( XBWin, &font ) ;  

/**** IS THIS NECESSARY?,  SEEMS TO BE THE ONLY WAY TO GET FONTS TO WORK ****/
  {
    XGCValues  values ;
    values.font = font.fnt ;
    XChangeGC( XBWin->disp, XBWin->gc.set, GCFont, &values ) ; 
  }

  info = VFPInit( XBWin, &font, 36, 30, 30, 50, 100 ) ;
  VFPFillProcCoordGrid2d( info, width-110, height-255, 6, 6 ) ;
    /*VFPFillProcCoordGrid( info, width-110, height-255) ;*/

/**************/
  pix1 = XCreatePixmapFromBitmapData( XBWin->disp, XBWin->win, 
      ltgrey, 8, 8, 1, 0, 1);  
  pix2 = XCreatePixmapFromBitmapData( XBWin->disp, XBWin->win, 
      white, 8, 8, 1, 0, 1);  

  XBFindColor( info->XBWin, "grey", &pixval1 );
  XBFindColor( info->XBWin, "white", &pixval2 );

  Box1 = (XB3DBoxStruct*)XBInit3DBox( 1, 1, height-5, width-5, 5, 1, pix1, 
	     pixval1 ) ;
  Box2 = (XB3DBoxStruct*)XBInit3DBox( 50, 100, height-255, width-105, 3, 0, pix2,
             pixval2 ) ;
  XBDraw3DBox( XBWin, Box1 ) ;
  XBDraw3DBox( XBWin, Box2 ) ;
  XBFree3DBox( Box1 ) ;  
  XBFree3DBox( Box2 ) ; 

  text_info = (XBTextBoxStruct*)XBInitTextBox( 50, 35, width-105, 30, CENTER, 
      "Processor - State & Message Display" ) ;
  XBDrawTextBox( XBWin, &font, text_info ) ;
  XBFreeTextBox( text_info ) ;

  VFPDrawProcRects( info ) ;


  if( VFPSetMsgColor( info, 160, 32, 240, SIZE, 0 ) )
    /***** error handling should be here here ****/
    printf( "**** did not set message color correctly ****\n") ;

  VFPDoDemo( info, &font ) ;

  VFPFree( info ) ;

  sleep(5);
  /* getchar(); */

} /* end of main procedure */




VFPDoDemo( info, font )
     VFPInfo      *info ;
     XBFont       *font ;
{
/* Demo to changes states */
  int           i,j,
               *route ;
  Pixmap        pixmap1,
                pixmap2, pixmap3, pixmap4 ;
  XBWindow     *XBWin=info->XBWin ;

/***********/
  pixmap1 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
      grey, 8, 8, 1, 0, 1);  
  pixmap2 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
      ltgrey, 8, 8, 1, 0, 1);  
  pixmap3 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
      black, 8, 8, 1, 0, 1);  
  pixmap4 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
      grey, 8, 8, 1, 0, 1);  

  VFPDefineStateBW( info, WAIT, pixmap1 );
  VFPDefineStateBW( info, SEND, pixmap2 );
  VFPDefineStateBW( info, REC, pixmap3 );
  VFPDefineStateBW( info, WORK, pixmap4 );


  VFPDefineStateColor( info, WAIT, "red" );
  VFPDefineStateColor( info, SEND, "blue" );
  VFPDefineStateColor( info, REC, "yellow" );
  VFPDefineStateColor( info, WORK, "green" );

  VFPDrawIndex( XBWin, info, 50, 470, 395, 95, states, 4 ) ;

  for( i=0 ; i<info->num_processors ; i++ )
    {
      VFPSetState( info, i, WORK ) ; 
    }

  route = VFPMakeRoute( info, 26, 20 ) ;
  VFPDrawRoute( info, route, 5 ) ;
  VFPSetState( info, 26, SEND ) ; 
  VFPSetState( info, 20, REC ) ; 
  FREE( route ) ;

  route = VFPMakeRoute( info, 8, 16 ) ;
  VFPDrawRoute( info, route, 5 ) ;
  VFPSetState( info, 8, SEND ) ;
  VFPSetState( info, 16, REC ) ;
  FREE( route ) ;

  VFPSetState( info, 27, WAIT ) ;
  VFPSetState( info, 11, WAIT ) ;
  VFPSetState( info, 18, WAIT ) ;
  VFPSetState( info, 29, WAIT ) ;

}

