#ifndef lint
static char SCCSid[] = "@(#) ./xtools/text/fontman.c 07/23/93";
#endif

/*
   This file contains simple code to manage access to fonts, insuring that
   library routines access/load fonts only once
 */

#include "tools.h"
#include "xtools/basex11.h"

static XBFont *curfont = 0;
static int    fw = 0, fh = 0;
static XBFont font;

/*@
    XBFontFixed - Return a pointer to the selected font; loading it if 
                  necessary 

    Input Parameters:
.   XBWin - window
.   w,h   - requested width and height of a character
@*/
XBFont *XBFontFixed( XBWin, w, h )
XBWindow *XBWin;
int      w, h;
{
if (!curfont) {
    XBInitFonts( XBWin );
    }
if (w != fw || h != fh) {
    XBMatchFontSize( &font, w, h );
    fw = w;
    fh = h;
    /* if (curfont) ? unload current font ? */
    XBLoadFont( XBWin, &font );
    }
curfont = &font;
return curfont;
}
