#ifndef lint
static char SCCSid[] = "@(#) ./xtools/surface/surface.c 07/23/93";
#endif

/*
    This file creates a "surface plot" tool that contains a mesh.
    By default, the data is assumed scaled between 0 and 1 in all
    three directions.

    Need to enumerate the available controls.  These should include
    recomputing the scalings.
 */

#include "tools.h"
#include "xtools/basex11.h"

#if defined(FORTRANCAPS)
#define tisrfc_ TISRFC
#define t3per_ T3PER
#define tllne_ TLLNE
#elif !defined(FORTRANUNDERSCORE)
#define tisrfc_ tisrfc
#define t3per_ t3per
#define tllne_ tllne
#endif

static XBWindow *MyW;

/*@
   XBSurfaceDraw - Draw a "surface plot" of z(x,y) for a regular grid.

   Input Parameters:
.  XBWin - window to draw on
.  mesh  - mesh to plot
.  x,y   - grid lines
.  work  - work area, should be 4*max(nx,ny)*sizeof(double) in size
.  nx,ny - size of grid
.  mat   - rotation matrix
.  permat - perspective matrix
.  w,h    - width and height of the plot (in X coordinates)

   Note:
   mat and permat may be generated with the routine XBSurfaceComputeView
@*/
void XBSurfaceDraw( XBWin, mesh, x, y, work, nx, ny, mat, permat, w, h )
XBWindow *XBWin;
double   *mesh, *x, *y, *work, *mat, *permat;
int      nx, ny, w, h;
{
MyW     = XBWin;
tisrfc_( &nx, &ny, x, y, mesh, mat, permat, work, &w, &h );
}

/*@
     XBSurfaceComputeView - Compute transformation matrices for a view of
     a surface

     Input parameters:
.    r - distance from center to eye
.    theta - theta (angle from x in x-y plane)
.    phi  - phi (angle from z)

     Output parameters:
.    mat - viewing matrix (performs rotation)
.    permat - perspective matrix

     Note:
     mat and permat are input to the surface drawing routine XBSurfaceDraw
@*/
void XBSurfaceComputeView( r, theta, phi, mat, permat )
double r, theta, phi, *mat, *permat;
{
double      halfwid, R=r, Theta=theta, Phi=phi;
/* We need to transfer the values since the Fortran compiler may not
   properly handle address of arguments used in C */
t3per_( &Theta, &Phi, &R, mat, permat, &halfwid );
}

/* This is the interface routine to the surface drawer */
void tllne_( lx, ly, x, y )
int *lx, *ly, *x, *y;
{
int x1, x2, y1, y2;

/* Xtools_set_pix( MyW, ((Surface *)MyT->Private)->forepixel ); */
x1 = *lx + MyW->x ;
y1 = MyW->y + MyW->h - *ly;
x2 = *x  + MyW->x ;
y2 = MyW->y + MyW->h - *y;
/* may need to clip (x,y).(lx,ly) to (0,0).(w-1,h-1) */

XDrawLine( MyW->disp, XBDrawable(MyW), MyW->gc.set, x1, y1, x2, y2 );
}

void pnt_( x1, y1, x2, y2 )
int *x1, *y1, *x2, *y2;
{
printf( "Drawing (pnt) (%d,%d) to (%d,%d)\n", *x1, *y1, *x2, *y2 );
}

void pntr_( v )
double v[3];
{
printf( "Transforming (%e,%e,%e)\n", v[0], v[1], v[2] );
}
