#ifndef lint
static char SCCSid[] = "@(#) ./xtools/solid/solid.c 07/23/93";
#endif
/*
    This file creates a "solid plot" tool that contains a solid.
    By default, the data is assumed scaled between 0 and 1 in all
    three directions.

    This is OLD solidtools code; not yet part of tools.
 */

#include "tools.h"
#include "xtools/basex11.h"
#include "xtools/base3d.h"
#define max(a,b) (((a)>(b))?(a):(b))

void SolidRedraw();

typedef struct {
    GraphObject     Obj;
    double          r, theta, phi;
    Trans3d         Trans;
    double          *work;
    PixVal          backpixel;
    } Solid;

/*
    This routine refreshes the solid plot.
 */
void SolidRedraw( tool )
MyTool  *tool;
{
Solid       *solid;
MyWindow    *mywindow;

solid       = (Solid *)tool->Private;
if (!solid->tri) return;
mywindow    = tool->window;

Xtools_set_pix( mywindow, solid->backpixel );
XFillRectangle( mywindow->display, mywindow->window, mywindow->gc_set,
                tool->x, tool->y, tool->w, tool->h );
triangle_fill3d( mywindow, solid->nv, solid->nt, solid->x, solid->y, solid->z,
                 solid->tri, 0, solid->mat, solid->permat, solid->work,
                 (TriangleDepth *)(solid->work + 3*solid->nv) );
XFlush( mywindow->display );
}


/*
    Scale the user-provided data to lie in [0,1]^3
 */
SolidScale( tool, qaspect )
MyTool    *tool;
int       qaspect;     
{
Solid     *solid;

solid         = (Solid *) tool->Private;
if (qaspect) {
    /* find the min scaling for all directions */
    double sx, sy, sz, mx, my, mz;
    XtoolsFindScale( solid->x, solid->nv, &sx, &mx );
    XtoolsFindScale( solid->y, solid->nv, &sy, &my );
    XtoolsFindScale( solid->z, solid->nv, &sz, &mz );
    if (sy < sx) sx = sy;
    if (sz < sx) sx = sz;
    ApplyScale( solid->x, solid->nv, sx, mx );
    ApplyScale( solid->y, solid->nv, sx, my );
    ApplyScale( solid->z, solid->nv, sx, mz );
    }
else {
    doscale( solid->x, solid->nv );
    doscale( solid->y, solid->nv );
    doscale( solid->z, solid->nv );
    }
}
