#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"

#include <math.h>

extern XBWindow *XBQGetWindow();

/*@
     XBQSurface - display a surface plot on the display.

     This uses the "quick" window; if there is no "quick" window, 
     one is created

     Input Parameters:
     mesh - mesh of values
     x,y  - coordinates of mesh
     nx,ny - size of mesh
@*/
void XBQSurface( mesh, x, y, nx, ny )
double *mesh, *x, *y;
int    nx, ny;
{
int    i, j, n;
double *p, *px, *py, r, phi, theta, mat[16], permat[16], maxv, minv, *work;
XBWindow *XBWin = XBQGetWindow( "Surface", "" );

/* Generate a copy of mesh that is scaled into [-1,1] */
n    = nx * ny;
minv = maxv = mesh[0];
for (i=0; i<n; i++) {
    if (mesh[i] > maxv) maxv = mesh[i];
    else if (mesh[i] < minv) minv = mesh[i];
    }
p = (double *)MALLOC( nx * ny * sizeof(double) );      CHKPTR(p);
for (i=0; i<n; i++) 
    p[i] = (mesh[i] - minv) / ( maxv - minv );
px = (double *)MALLOC( (nx + ny) * sizeof(double ) );  CHKPTR(px);
py = px + nx;

/* if x,y, null, generate those too */
if (!x) 
    for (i=0; i<nx; i++) px[i] = i*(1.0/(nx-1));
else {
    }
if (!y)
    for (j=0; j<ny; j++) py[j] = j*(1.0/(ny-1));
else {
    }

work = (double *) MALLOC( 4*(nx + ny) * sizeof(double) );    CHKPTR(work);
r     = 10.0;
theta = 30.0;
phi   = 60.0;
XBSurfaceComputeView( r, theta, phi, mat, permat );
XBClearWindow( XBWin, 0, 0, XBWin->w, XBWin->h );
XSetForeground( XBWin->disp, XBWin->gc.set, XBWin->foreground );
XBSurfaceDraw( XBWin, p, x, y, work, nx, ny, mat, permat, 
	       XBWin->w, XBWin->h );
XBFlush( XBWin );

FREE( px );
FREE( p );
FREE( work );
}

