#ifndef LINT
static char SCCSid[]    = "@(#) ./xtools/pointer/activep.c 07/23/93";
#endif

/*
    This file contains routines to handle an active pointer.
    When the indicated button is pressed down, the provided
    routine is called continuously until the button is released.
    This is much like RBBOX.

    Note also that for the purposes of event handling,
    an active pointer is a "button"
 */

/* #define DBUG */
#ifdef DBUG
#include <stdio.h>
#endif

#include "tools.h"
#include "xtools/basex11.h"

/* @
   XBapoint - Call user routine with pointer (mouse) position

   Input Parameters:
.  XBWin - window
.  key   - release key
.  
 @ */
XBapoint( XBWin, key, user, usrp )
XBWindow        *XBWin;
unsigned int    key;
int             (*user)();
void            *usrp;
{
int         x1, y1, newx, newy, xl, yl, xh, yh;

if (key != Button1) {
    /* wait for release of the button */
    XBWaitButton( XBWin, key );
    return;
    }

XBSaveWindowMask( XBWin );
/* Not right; we don't want to change cursor until button pressed */
XSelectInput( XBWin->disp, XBWin->win, ButtonPressMask | ButtonReleaseMask );
XBdrag_cursor( XBWin );

/* set location of first corner of box */
x1  = 0;
y1  = 0;
xl  = XBWin->x;
yl  = XBWin->y;
xh  = xl + XBWin->w;
yh  = yl + XBWin->h;
/* while left button is dragged, call user routine */
XBstart_drag( XBWin );
while (!XBdo_drag( XBWin, Button1, &newx, &newy )) {
    /* clip motion within the specified region */
    if (newx < xl)      newx  = xl;
    else if (newx > xh) newx  = xh;
    if (newy < yl)      newy  = yl;
    else if (newy > yh) newy  = yh;
    if ((*user)( XBWin, x1, y1, newx, newy, 0, usrp )) break;
    }
XBrestore_cursor( XBWin );

/* return the corner point (relative to a lower-left origin) */
(*user)( XBWin, 0, 0, newx, newy, 1, usrp );

XBRestoreWindowMask( XBWin );
}
