#ifdef FOO
From yale!decvax!decwrl!ucbvax!ucsfcgl!pixar!fishkin Wed May 11 13:57:01 EDT 1988

About a week ago, somebody asked for an HSL to RGB algorithm.

    A while ago, I figured out how to optimize that alg.
so it's just about the same speed as HSV to RGB (the standard is
about twice as slow). We decided it wasn't worth publishing and buried
it in my thesis, but if anybody out there can use it, here it is.

----------------------------------------------------------
/*
* given [h,s,l] on [0..1], return RGB on [0..1]
*/
HSLxRGB(h,s,l,R,G,B)
double h,s,l;
double *R,*G,*B;
{
    double v,min,sv,vsf;
    int sextant;
    double fract;
    double mid1,mid2;

	/* compute V */
    if (l <= 0.5) {
	v = l*(1.0+s);
    } else {
	v = l + s - l*s;
    }
    if (v == 0.0) {
	*R = *G = *B = 0.0;
	return;
    }
    min = l + l - v;
	/* compute S in HSV space */
    sv = (v - min) / v;
	/* HSV to RGB from here on */
    h *= 6.0;
    sextant = (int) h; /* implicit floor */
    fract = h - sextant;
    vsf = v*sv*fract;
    mid1 = min + vsf;
    mid2 = v - vsf;
    switch (sextant) {
    case 0: *R = v; *G = mid1; *B = min; break;
    case 1: *R = mid2; *G = v; *B = min; break;
    case 2: *R = min; *G = v; *B = mid1; break;
    case 3: *R = min; *G = mid2; *B = v; break;
    case 4: *R = mid1; *G = min; *B = v; break;
    case 5: *R = v; *G = min; *B = mid2; break;
    }
}
-- 
Ken Fishkin	...{ucbvax,sun}!pixar!fishkin


#endif
