#ifndef lint
static char SCCSid[] = "@(#) ./xtools/contour/dither.c 07/23/93";
#endif

/*
    This file contains simple routines to dither a color contour map
    to a monochrome image.  It must use a power of 2 number of colors
    (16 is a good choice).
 */

#include "tools.h"

/*
    Make a dithering matrix of size n x n, and return it im m.
    m is stored in ROW major order
 */
void XBFormDitherMatrix( n, m )
int             n;
unsigned char   **m;
{
unsigned char   *mm, *m2, *mp, *m2p;
int             j, nn;

mm  = (unsigned char *) MALLOC( n * n );   CHKPTR(mm);
if (!mm) {
    *m  = (unsigned char *)0;
    return;
    }
if (n == 2) {
    mm[0]   = 0;
    mm[1]   = 2;
    mm[2]   = 3;
    mm[3]   = 1;
    }
else {
    XBFormDitherMatrix( n/2, &m2 );
    /*  m   = 4 * m2 + [0,2;3,1] */
    mp  = mm;
    for (j=0; j<n/2; j++) {
	nn  = n/2;
	m2p = m2 + j * n/2;
	while (nn--)
	    *mp++   = 4 * *m2p++;
	nn  = n/2;
	m2p = m2 + j * n/2;
	while (nn--)
	    *mp++   = 4 * *m2p++ + 2;
	}
    for (j=0; j<n/2; j++) {
	nn  = n/2;
	m2p = m2 + j * n/2;
	while (nn--)
	    *mp++   = 4 * *m2p++ + 3;
	nn  = n/2;
	m2p = m2 + j * n/2;
	while (nn--)
	    *mp++   = 4 * *m2p++ + 1;
	}
    FREE( m2 );
    }
*m  = mm;
}

/*
    Apply the dithering matrix m to the intensity map b,
    replacing the values in b by 0 or 1
    input parameters:
	b       - intensity values (reset on output)
	m       - dither matrix (see FormDitherMatrix)
	nx, ny  - sizes of b (no padding!)
	n       - size of side of dithering matrix
	ox, oy  - offset (used to insure that dithering "tiles" properly),
		  this should be the location in the window of the image
 */
void XBApplyDither( b, m, nx, ny, n, ox, oy )
unsigned char   *b, *m;
int             nx, ny, n, ox, oy;
{
int                     j, jj;
register unsigned char  *dp;
register int            nn, ii;
int                     iioff = ox % n;

jj  = oy % n;
for (j = 0; j<ny; j++) {
    nn  = nx;
    ii  = iioff;
    dp = m + jj * n + ii;
    /* we can remove one of these tests by doing n of the points
       at a time, or by doing wordsize at a time. */
    while (nn--) {
	if (++ii > n) {
	    dp  = m + jj * n;
	    ii  = 0;
	    }
	*b  = (*b > *dp++);
	b++;
	}
    if (++jj > n)   jj  = 0;
    }
}
