#ifndef lint
static char SCCSid[] = "@(#) ./xtools/contour/contour.c 07/23/93";
#endif
/*
    This file creates a contour map.
    We allow for the user to draw subcontour maps within a "contour" tool.

    Other options:
        Save the data needed to redraw the plot
        Offset the contour map colors.
 */

#include "tools.h"
#include "xtools/basex11.h"

extern void XBSetmap();

/* map needs to be nx * ny * sizeof(char) for 8-bit colors */

/*@
    XBContourDrawWithMap - Draw a contour plot on the display

    Input parameters:
.    matrix - array of data (mx x my)
.    x,y    - x/y values of coordinate lines of matrix
.    imap   - color mapping
.    nc     - number of colors
.    nx,ny  - size of contour plot in pixels
.    xoff,yoff - location in window of upper left corner (often 0,0)
.    coff      - min colormap INDEX.

    Note:
    Actually draw the contour plot with a user provided map in the
    given area.
@*/
void XBContourDrawWithMap( XBWin, matrix, mx, my, x, y, imap, nc, map, 
                           nx, ny, xoff, yoff, coff )
XBWindow        *XBWin;
int             mx, my, nx, ny, nc, xoff, yoff, coff;
double          *matrix, *x, *y;
double          *imap;
unsigned char   *map;
{
XBSetmap( map, nx, ny, matrix, mx, my, x, y, nc, imap, coff );
XBContourDrawWithSetMap( XBWin, map, xoff, yoff, nx, ny );
}

void XBContourDrawWithMapYup( XBWin, matrix, mx, my, x, y, imap, nc, map, 
			      nx, ny, xoff, yoff, coff )
XBWindow        *XBWin;
int             mx, my, nx, ny, nc, xoff, yoff, coff;
double          *matrix, *x, *y;
double          *imap;
unsigned char   *map;
{
XBSetmap2( map, nx, ny, matrix, mx, mx, my, x, y, nc, imap, coff );
XBContourDrawWithSetMap( XBWin, map, xoff, yoff, nx, ny );
}

/*
    Draw a given map at the selected position.
    If a monochrome output device is being used, the map will
    be dithered.
 */
XBContourDrawWithSetMap( XBWin, map, xoff, yoff, nx, ny )
XBWindow        *XBWin;
unsigned char   *map;
int             xoff, yoff, nx, ny;
{
if (XBWin->numcolors == 2) {
    int     nc = 4;            /* for now */
    unsigned char *dither_mat;
    XBFormDitherMatrix( nc, &dither_mat );
    XBApplyDither( map, dither_mat, nx, ny, nc, xoff, yoff );
    FREE( dither_mat );
    }
XB_w_map_off( XBWin, map, nx, ny, xoff, yoff );
}
