#ifndef lint
static char SCCSid[] = "@(#) ./sparse/values.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

/*@
  SpGetDiagonal - Get the values in a diagonal. 

  Input parameters:
.  mat     - matrix
.  diag    - diagonal to use: row - column == diag
.  sr er   - start and end rows
.  vals    - pointer to storage in which values are returned
 @*/
void SpGetDiagonal(mat,diag,sr,er,vals)
SpMat  *mat;
int    diag, sr, er;
double *vals;
{
int      i, j, *ix, nz;
double   *v;

SPLITTOMAT(mat);
if (sr < 0) sr = 0;
if (er >= mat->rows) er = mat->rows - 1;

for (i=sr; i<=er; i++) {
    SpScatterFromRow( mat, i, &nz, &ix, &v );
    *vals = 0.0;
    for (j=0; j<nz; j++) {
	if (i - ix[j] == diag) {
	    *vals = v[j];
	    break;
	    }
	}
    vals++;
    }
}

/*@
  SpGetInRow - Return values for a given set of column indices in a given
               row.

  Input Parameters:
.  mat    - matrix
.  row    - row to get values from
.  cols   - columns
.  n      - number of columns
  
  Output Parameters:
.  vals   - corresponding output values
 @*/
void SpGetInRow( mat, row, cols, n, vals )
SpMat  *mat;
int    row, *cols, n;
double *vals;
{
int i;

SPLITTOMAT(mat);
for (i=0; i<n; i++) 
    vals[i] = SpGetValue( mat, row, cols[i] );
}

/*@
  SpGetValue - Return a single value.  Return 0 if out-of-range or not set.

  Input Parameters:
. mat  - matrix
. row  - row 
. col  - column

  Return: 
  value of mat(row,col).
 @*/
double SpGetValue( mat, row, col )
SpMat *mat;
int   row, col;
{
int    *cls, nz, j;
double *v;

SPLITTOMAT(mat);
if (row < 0 || row >= mat->rows) return 0.0;

SpScatterFromRow( mat, row, &nz, &cls, &v );
for (j=0; j<nz; j++) 
    if (*cls++ == col) return v[j];
return 0.0;
}
