#ifndef lint
static char SCCSid[] = "@(#) ./sparse/solveadd.c 07/23/93";
#endif

/*
    This file contains a simple sparse solve routine.
    These are intended for problems where the matrix is re-ordered
    to improve performance (e.g., numerical stability, reduction of fill)
 */

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "inline/spops.h"

void SpiSolveAddPerm(), SpiSolveAddPermBase(), SpiSolveAddBase();

/*@ 
  SpSolveAdd - Solve a system of equations and add the result to a vector.

  Input Parameters:
.  BB - Split matrix already processed by Factor
.  b  - Right-hand-side
.  y  - solution is added to this vector
.  x  - combined solution

 @*/
void SpSolveAdd( BB, b, y, x )
SpMatSplit *BB;
double     *y, *b, *x;
{
if (BB->factor->map) 
    SpiSolveAddPerm( BB, y, b, x );
else
    SpiSolveAddBase( BB, y, b, x );
}

/*
        [(R A C) Cinv] x = R b
 */
void SpiSolveAddPerm( BB, y, b, x )
SpMatSplit *BB;
double     *y, *x, *b;
{
double *tmp;
tmp    = (double *)SPAllocTemp(BB->factor->rows * sizeof(double)); CHKPTR(tmp);
SpiSolveAddPermBase( BB, y, b, tmp, x );
SPFreeTemp( tmp );
}

void SpiSolveAddPermBase( BB, y, b, Tmp, x )
SpMatSplit *BB;
double      *x, *b, *Tmp, *y;
{
int          i, n, *nzs;
double   *vv;
register double       *v, sum, *tmp = Tmp;
register int          *vi, nz;
SpMat    *B = BB->factor;
SpVec    *row, **rs;
int      *r = B->map->rowmap, *c = B->map->colmap;
SpRowMat *R = (SpRowMat *)B->data;

n      = B->rows;
/* forward solve the lower triangular */
nzs    = BB->nzl + 1;
rs     = R->rs + 1;
tmp[0] = b[*r++];
for (i=1; i<n; i++) {
    row  = *rs++;
    v    = row->v;
    vi   = row->i;
    nz   = *nzs++;
    sum  = b[*r++];
    SPARSEDENSEMDOT(sum,tmp,v,vi,nz);
    tmp[i] = sum;
    }

/* backward solve the upper triangular */
nzs--; rs--;
c = c + (n-1);
/* y = y + n; */
for (i=n-1; i>=0; i--) {
    nz   = *nzs-- + 1;
    row  = *rs--;
    vv = v = row->v + nz;
    vi   = row->i + nz;
    nz   = row->nz - nz;
    sum  = tmp[i];
    SPARSEDENSEMDOT(sum,tmp,v,vi,nz);
    tmp[i] = sum * *(vv-1);
    /* x[*c--] = *y-- + tmp[i]; */
    x[*c] = y[*c] + tmp[i];
    c--;
    }
}

/*
   This is a solve that does not involve any mappings 
 */
void SpiSolveAddBase( BB, y, b, x )
SpMatSplit  *BB;
double      *x, *b, *y;
{
int          i, n, *nzs;
double   *vv;
register double       *v, sum;
register int          *vi, nz;
SpMat    *B = BB->factor;
SpVec    *row, **rs;
SpRowMat *R = (SpRowMat *)B->data;

n      = B->rows;
/* forward solve the lower triangular */
nzs    = BB->nzl + 1;
rs     = R->rs + 1;
x[0]   = *b++;
for (i=1; i<n; i++) {
    row  = *rs++;
    v    = row->v;
    vi   = row->i;
    nz   = *nzs++;
    sum  = *b++;
    SPARSEDENSEMDOT(sum,x,v,vi,nz);
    x[i] = sum;
    }

/* backward solve the upper triangular */
nzs--; rs--;
for (i=n-1; i>=0; i--) {
    nz   = *nzs-- + 1;
    row  = *rs--;
    vv = v = row->v + nz;
    vi   = row->i + nz;
    nz   = row->nz - nz;
    sum  = x[i];
    SPARSEDENSEMDOT(sum,x,v,vi,nz);
    x[i] = sum * *(vv-1);
    }
/* For now, add at the end.  By using temps, we could eliminate this separate
   step */
for (i=0; i<n; i++) 
    *x++ += *y++;
}


