#ifndef lint
static char SCCSid[] = "@(#) ./sparse/scale.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

/*@
  SpScaleRowsByDiag - Scale each row of a matrix by a diagonal matrix
                      stored as a vector.

  Input parameters:
.  mat   - matrix to scale.
.  diag  - array of scaling factors.  Should be the same size as the number
          of rows in the matrix
 @*/
void SpScaleRowsByDiag( mat, diag )
SpMat  *mat;
double *diag;
{
int      size,i,j,nz;
double   di,*vx;

SPLITTOMAT(mat);
size = mat->rows;

for ( i=0; i<size; i++ ) {
    di = diag[i];
    if (di != 0.0) {
	SpScatterFromRow( mat, i, &nz, (int *)0, &vx );
	for ( j=0; j<nz; j++ ) {
	    vx[j] *= di;
	    }
	/* BUG - Won't work if vx is not the actual storage area */
	}
    }
}

/*@
  SpScaleColsByDiag - Scale each column of a matrix by a diagonal matrix
                      stored as a vector.

  Input parameters:
.  mat   - matrix to scale.
.  diag  - array of scaling factors.  Should be the same size as the number
          of columns in the matrix
 @*/
void SpScaleColsByDiag( mat, diag )
SpMat  *mat;
double *diag;
{
int      size,i,j,nz,*vi;
double   di,*vx;

SPLITTOMAT(mat);
size = mat->rows;

for ( i=0; i<size; i++ ) {
    SpScatterFromRow( mat, i, &nz, &vi, &vx );
    for ( j=0; j<nz; j++ ) {
	di = diag[vi[j]];
	if (di != 0.0) {
	    vx[j] *= di;
	    }
	}
    }
}

/*@
  SpScaleSym - Symmetric diagonal scale of sparse matrix. 

  Input parameters:
.  mat   - matrix to scale.
.  diag  - array of scaling factors.  Should be the same size as the number
          of rows and columns in the matrix
 @*/
void SpScaleSym( mat, diag )
SpMat  *mat;
double *diag;
{
int      size,i,j,nz,*ix;
double   di,*vx;

SPLITTOMAT(mat);
size = mat->rows;

for ( i=0; i<size; i++ ) {
    SpScatterFromRow( mat, i, &nz, &ix, &vx );
    di = diag[i];
    for ( j=0; j<nz; j++ ) {
	vx[j] *= di*diag[ix[j]];
        }
    }
}


