C----- SUBROUTINE QMDQT
C*************************************************************             1.
C*************************************************************             2.
C*******     QMDQT  ..... QUOT MIN DEG QUOT TRANSFORM  *******             3.
C*************************************************************             4.
C*************************************************************             5.
C                                                                          6.
C     PURPOSE - THIS SUBROUTINE PERFORMS THE QUOTIENT GRAPH                7.
C        TRANSFORMATION AFTER A NODE HAS BEEN ELIMINATED.                  8.
C                                                                          9.
C     INPUT PARAMETERS -                                                  10.
C        ROOT - THE NODE JUST ELIMINATED. IT BECOMES THE                  11.
C               REPRESENTATIVE OF THE NEW SUPERNODE.                      12.
C        (XADJ, ADJNCY) - THE ADJACENCY STRUCTURE.                        13.
C        (RCHSZE, RCHSET) - THE REACHABLE SET OF ROOT IN THE              14.
C               OLD QUOTIENT GRAPH.                                       15.
C        NBRHD - THE NEIGHBORHOOD SET WHICH WILL BE MERGED                16.
C               WITH ROOT TO FORM THE NEW SUPERNODE.                      17.
C        MARKER - THE MARKER VECTOR.                                      18.
C                                                                         19.
C     UPDATED PARAMETER -                                                 20.
C        ADJNCY - BECOMES THE ADJNCY OF THE QUOTIENT GRAPH.               21.
C                                                                         22.
C*************************************************************            23.
C                                                                         24.
      SUBROUTINE  QMDQT ( ROOT, XADJ, ADJNCY, MARKER,                     25.
     1                    RCHSZE, RCHSET, NBRHD )                         26.
C                                                                         27.
C*************************************************************            28.
C                                                                         29.
         INTEGER ADJNCY(1), MARKER(1), RCHSET(1), NBRHD(1)                30.
         INTEGER XADJ(1), INHD, IRCH, J, JSTRT, JSTOP, LINK,              31.
     1           NABOR, NODE, RCHSZE, ROOT                                32.
C                                                                         33.
C*************************************************************            34.
C                                                                         35.
         IRCH = 0                                                         36.
         INHD = 0                                                         37.
         NODE = ROOT                                                      38.
  100    JSTRT = XADJ(NODE)                                               39.
         JSTOP = XADJ(NODE+1) - 2                                         40.
         IF ( JSTOP .LT. JSTRT )  GO TO 300                               41.
C           ------------------------------------------------              42.
C           PLACE REACH NODES INTO THE ADJACENT LIST OF NODE              43.
C           ------------------------------------------------              44.
            DO 200 J = JSTRT, JSTOP                                       45.
               IRCH = IRCH + 1                                            46.
               ADJNCY(J) = RCHSET(IRCH)                                   47.
               IF ( IRCH .GE. RCHSZE )  GOTO 400                          48.
  200       CONTINUE                                                      49.
C        ----------------------------------------------                   50.
C        LINK TO OTHER SPACE PROVIDED BY THE NBRHD SET.                   51.
C        ----------------------------------------------                   52.
  300    LINK = ADJNCY(JSTOP+1)                                           53.
         NODE = - LINK                                                    54.
         IF ( LINK .LT. 0 )  GOTO 100                                     55.
            INHD = INHD + 1                                               56.
            NODE = NBRHD(INHD)                                            57.
            ADJNCY(JSTOP+1) = - NODE                                      58.
            GO TO 100                                                     59.
C        -------------------------------------------------------          60.
C        ALL REACHABLE NODES HAVE BEEN SAVED.  END THE ADJ LIST.          61.
C        ADD ROOT TO THE NBR LIST OF EACH NODE IN THE REACH SET.          62.
C        -------------------------------------------------------          63.
  400    ADJNCY(J+1) = 0                                                  64.
         DO 600 IRCH = 1, RCHSZE                                          65.
            NODE = RCHSET(IRCH)                                           66.
            IF ( MARKER(NODE) .LT. 0 )  GOTO 600                          67.
               JSTRT = XADJ(NODE)                                         68.
               JSTOP = XADJ(NODE+1) - 1                                   69.
               DO 500 J = JSTRT, JSTOP                                    70.
                  NABOR = ADJNCY(J)                                       71.
                  IF ( MARKER(NABOR) .GE. 0 ) GO TO 500                   72.
                     ADJNCY(J) = ROOT                                     73.
                     GOTO 600                                             74.
  500          CONTINUE                                                   75.
  600    CONTINUE                                                         76.
         RETURN                                                           77.
      END                                                                 78.
