C----- SUBROUTINE FNDSEP
C***************************************************************           1.
C***************************************************************           2.
C************     FNDSEP ..... FIND SEPARATOR       ************           3.
C***************************************************************           4.
C***************************************************************           5.
C                                                                          6.
C     PURPOSE - THIS ROUTINE IS USED TO FIND A SMALL                       7.
C               SEPARATOR FOR A CONNECTED COMPONENT SPECIFIED              8.
C               BY MASK IN THE GIVEN GRAPH.                                9.
C                                                                         10.
C     INPUT PARAMETERS -                                                  11.
C        ROOT - IS THE NODE THAT DETERMINES THE MASKED                    12.
C               COMPONENT.                                                13.
C        (XADJ, ADJNCY) - THE ADJACENCY STRUCTURE PAIR.                   14.
C                                                                         15.
C     OUTPUT PARAMETERS -                                                 16.
C        NSEP - NUMBER OF VARIABLES IN THE SEPARATOR.                     17.
C        SEP - VECTOR CONTAINING THE SEPARATOR NODES.                     18.
C                                                                         19.
C     UPDATED PARAMETER -                                                 20.
C        MASK - NODES IN THE SEPARATOR HAVE THEIR MASK                    21.
C               VALUES SET TO ZERO.                                       22.
C                                                                         23.
C     WORKING PARAMETERS -                                                24.
C        (XLS, LS) - LEVEL STRUCTURE PAIR FOR LEVEL STRUCTURE             25.
C               FOUND BY FNROOT.                                          26.
C                                                                         27.
C     PROGRAM SUBROUTINES -                                               28.
C        FNROOT.                                                          29.
C                                                                         30.
C***************************************************************          31.
C                                                                         32.
      SUBROUTINE  FNDSEP ( ROOT, XADJ, ADJNCY, MASK,                      33.
     1                     NSEP, SEP, XLS , LS )                          34.
C                                                                         35.
C***************************************************************          36.
C                                                                         37.
         INTEGER ADJNCY(1), LS(1), MASK(1), SEP(1), XLS(1)                38.
         INTEGER XADJ(1), I, J, JSTOP, JSTRT, MIDBEG,                     39.
     1           MIDEND, MIDLVL, MP1BEG, MP1END,                          40.
     1           NBR, NLVL, NODE, NSEP, ROOT                              41.
C                                                                         42.
C***************************************************************          43.
C                                                                         44.
         CALL  FNROOT ( ROOT, XADJ, ADJNCY, MASK,                         45.
     1                  NLVL, XLS, LS )                                   46.
C        ----------------------------------------------                   47.
C        IF THE NUMBER OF LEVELS IS LESS THAN 3, RETURN                   48.
C        THE WHOLE COMPONENT AS THE SEPARATOR.                            49.
C        ----------------------------------------------                   50.
         IF ( NLVL .GE. 3 )  GO TO 200                                    51.
            NSEP = XLS(NLVL+1) - 1                                        52.
            DO 100 I = 1, NSEP                                            53.
               NODE = LS(I)                                               54.
               SEP(I) = NODE                                              55.
               MASK(NODE) = 0                                             56.
  100       CONTINUE                                                      57.
            RETURN                                                        58.
C        ----------------------------------------------------             59.
C        FIND THE MIDDLE LEVEL OF THE ROOTED LEVEL STRUCTURE.             60.
C        ----------------------------------------------------             61.
  200    MIDLVL = (NLVL + 2)/2                                            62.
         MIDBEG = XLS(MIDLVL)                                             63.
         MP1BEG = XLS(MIDLVL + 1)                                         64.
         MIDEND = MP1BEG - 1                                              65.
         MP1END = XLS(MIDLVL+2) - 1                                       66.
C        -------------------------------------------------                67.
C        THE SEPARATOR IS OBTAINED BY INCLUDING ONLY THOSE                68.
C        MIDDLE-LEVEL NODES WITH NEIGHBORS IN THE MIDDLE+1                69.
C        LEVEL. XADJ IS USED TEMPORARILY TO MARK THOSE                    70.
C        NODES IN THE MIDDLE+1 LEVEL.                                     71.
C        -------------------------------------------------                72.
         DO 300 I = MP1BEG, MP1END                                        73.
            NODE = LS(I)                                                  74.
            XADJ(NODE) = - XADJ(NODE)                                     75.
  300    CONTINUE                                                         76.
         NSEP  = 0                                                        77.
         DO 500 I = MIDBEG, MIDEND                                        78.
            NODE = LS(I)                                                  79.
            JSTRT = XADJ(NODE)                                            80.
            JSTOP = IABS(XADJ(NODE+1)) - 1                                81.
            DO 400 J = JSTRT, JSTOP                                       82.
               NBR = ADJNCY(J)                                            83.
               IF ( XADJ(NBR) .GT. 0 )  GO TO 400                         84.
                  NSEP = NSEP + 1                                         85.
                  SEP(NSEP) = NODE                                        86.
                  MASK(NODE) = 0                                          87.
                  GO TO 500                                               88.
  400       CONTINUE                                                      89.
  500    CONTINUE                                                         90.
C        -------------------------------                                  91.
C        RESET XADJ TO ITS CORRECT SIGN.                                  92.
C        -------------------------------                                  93.
         DO 600 I = MP1BEG, MP1END                                        94.
            NODE = LS(I)                                                  95.
            XADJ(NODE) = - XADJ(NODE)                                     96.
  600    CONTINUE                                                         97.
         RETURN                                                           98.
      END                                                                 99.
