C----- SUBROUTINE DEGREE
C***************************************************************           1.
C***************************************************************           2.
C********     DEGREE ..... DEGREE IN MASKED COMPONENT   ********           3.
C***************************************************************           4.
C***************************************************************           5.
C                                                                          6.
C     PURPOSE - THIS ROUTINE COMPUTES THE DEGREES OF THE NODES             7.
C        IN THE CONNECTED COMPONENT SPECIFIED BY MASK AND ROOT.            8.
C        NODES FOR WHICH MASK IS ZERO ARE IGNORED.                         9.
C                                                                         10.
C     INPUT PARAMETER -                                                   11.
C        ROOT - IS THE INPUT NODE THAT DEFINES THE COMPONENT.             12.
C        (XADJ, ADJNCY) - ADJACENCY STRUCTURE PAIR.                       13.
C        MASK - SPECIFIES A SECTION SUBGRAPH.                             14.
C                                                                         15.
C     OUTPUT PARAMETERS -                                                 16.
C        DEG - ARRAY CONTAINING THE DEGREES OF THE NODES IN               17.
C              THE COMPONENT.                                             18.
C        CCSIZE-SIZE OF THE COMPONENT SPECIFED BY MASK AND ROOT           19.
C                                                                         20.
C     WORKING PARAMETER -                                                 21.
C        LS - A TEMPORARY VECTOR USED TO STORE THE NODES OF THE           22.
C               COMPONENT LEVEL BY LEVEL.                                 23.
C                                                                         24.
C***************************************************************          25.
C                                                                         26.
      SUBROUTINE  DEGREE ( ROOT, XADJ, ADJNCY, MASK,                      27.
     1                     DEG, CCSIZE, LS )                              28.
C                                                                         29.
C***************************************************************          30.
C                                                                         31.
         INTEGER ADJNCY(1), DEG(1), LS(1), MASK(1)                        32.
         INTEGER XADJ(1), CCSIZE, I, IDEG, J, JSTOP, JSTRT,               33.
     1           LBEGIN, LVLEND, LVSIZE, NBR, NODE, ROOT                  34.
C                                                                         35.
C***************************************************************          36.
C                                                                         37.
C        -------------------------------------------------                38.
C        INITIALIZATION ...                                               39.
C        THE ARRAY XADJ IS USED AS A TEMPORARY MARKER TO                  40.
C        INDICATE WHICH NODES HAVE BEEN CONSIDERED SO FAR.                41.
C        -------------------------------------------------                42.
         LS(1) = ROOT                                                     43.
         XADJ(ROOT) = -XADJ(ROOT)                                         44.
         LVLEND = 0                                                       45.
         CCSIZE = 1                                                       46.
C        -----------------------------------------------------            47.
C        LBEGIN IS THE POINTER TO THE BEGINNING OF THE CURRENT            48.
C        LEVEL, AND LVLEND POINTS TO THE END OF THIS LEVEL.               49.
C        -----------------------------------------------------            50.
  100    LBEGIN = LVLEND + 1                                              51.
         LVLEND = CCSIZE                                                  52.
C        -----------------------------------------------                  53.
C        FIND THE DEGREES OF NODES IN THE CURRENT LEVEL,                  54.
C        AND AT THE SAME TIME, GENERATE THE NEXT LEVEL.                   55.
C        -----------------------------------------------                  56.
         DO 400 I = LBEGIN, LVLEND                                        57.
            NODE = LS(I)                                                  58.
            JSTRT = -XADJ(NODE)                                           59.
            JSTOP = IABS(XADJ(NODE + 1)) - 1                              60.
            IDEG = 0                                                      61.
            IF ( JSTOP .LT. JSTRT ) GO TO 300                             62.
               DO 200 J = JSTRT, JSTOP                                    63.
                  NBR = ADJNCY(J)                                         64.
                  IF ( MASK(NBR) .EQ. 0 )  GO TO  200                     65.
                     IDEG = IDEG + 1                                      66.
                     IF ( XADJ(NBR) .LT. 0 ) GO TO 200                    67.
                        XADJ(NBR) = -XADJ(NBR)                            68.
                        CCSIZE = CCSIZE + 1                               69.
                        LS(CCSIZE) = NBR                                  70.
  200          CONTINUE                                                   71.
  300       DEG(NODE) = IDEG                                              72.
  400    CONTINUE                                                         73.
C        ------------------------------------------                       74.
C        COMPUTE THE CURRENT LEVEL WIDTH.                                 75.
C        IF IT IS NONZERO , GENERATE ANOTHER LEVEL.                       76.
C        ------------------------------------------                       77.
         LVSIZE = CCSIZE - LVLEND                                         78.
         IF ( LVSIZE .GT. 0 ) GO TO 100                                   79.
C        ------------------------------------------                       80.
C        RESET XADJ TO ITS CORRECT SIGN AND RETURN.                       81.
C        ------------------------------------------                       82.
         DO 500 I = 1, CCSIZE                                             83.
            NODE = LS(I)                                                  84.
            XADJ(NODE) = -XADJ(NODE)                                      85.
  500    CONTINUE                                                         86.
         RETURN                                                           87.
      END                                                                 88.
