#ifndef lint
static char SCCSid[] = "@(#) ./sparse/default/dfmult.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "inline/spops.h"

/* 
   This file contains the default matrix-vector multiply routines
 */

SpDfMult( mat, x, mx )
SpMat  *mat;
double *x, *mx;
{
int    i, nz, *xi, n;
double *xv, sum;

n      = mat->rows;
for (i=0; i<n; i++) {
    SpScatterFromRow( mat, i, &nz, &xi, &xv );
    sum = 0.0;
    SPARSEDENSEDOT(sum,x,xv,xi,nz);
    mx[i] = sum;
    }
}

SpDfMultAdd( mat, x, vin, vout )
SpMat  *mat;
double *x, *vin, *vout;
{
int    i, nz, *xi, n;
double *xv, sum;

n      = mat->rows;
for (i=0; i<n; i++) {
    SpScatterFromRow( mat, i, &nz, &xi, &xv );
    sum = 0.0;
    SPARSEDENSEDOT(sum,x,xv,xi,nz);
    vout[i] = vin[i] + sum;
    }
}

SpDfMultTrans( mat, x, mtx )
SpMat  *mat;
double *x, *mtx;
{
int    i, nz, *xi, n;
double *xv, alpha;

n      = mat->rows;
for (i=0; i<n; i++) mtx[i] = 0.0;
for (i=0; i<n; i++) {
    SpScatterFromRow( mat, i, &nz, &xi, &xv );
    alpha = - x[i];
    SPARSEDENSESMAXPY(mtx,alpha,xv,xi,nz);
    }
}
