#include "solvers/svctx.h"

/*
   SViMult - Applies a matrix multiply to a serial double precision
   vector, the matrix in sparse format is hidden in the SVctx. 
 */

void SViMult(ctx,x,y)
SVctx  *ctx;
double *x,*y;
{
  ctx->namult++;
  SpMult(ctx->amat,x,y);
}

/*
  SViMultTrans - Applies a matrix-transpose multiply to a serial 
  double precision vector
 */
void SViMultTrans(ctx,x,y)
SVctx  *ctx;
double *x, *y;
{
  ctx->namult++;
  SpMultTrans( ctx->amat, x, y );
}
