/*
    These are some routines needed for the incomplete Choleski
  preconditioner.
*/
#include "solvers/svctx.h"
#include "solvers/svpriv.h"
#include <math.h>
/*------------------------------------------------------------------*/
/*ARGSUSED*/
void SViCreateICC(ctx,mat)
SVctx *ctx;
SpMat *mat;
{
  SVICCctx *lctx;
  lctx = NEW(SVICCctx); CHKPTR(lctx);
  ctx->method = ITCG;
  ctx->private = (void *) lctx;
  ctx->is_iter = 1;

  ctx->setup   = SViSetupICC;
  ctx->solve   = SViSolveICC;
  ctx->destroy = SViDestroyICC;
}

/*------------------------------------------------------------------*/
void SViSetupICC(ctx)
SVctx *ctx;
{
  SVICCctx *lctx = (SVICCctx *) ctx->private;
  int         i,n = ctx->size;
  double      t1;

  t1 = SYGetCPUTime();
  ctx->itctx = ITCreate(ctx->method);    CHKERR(1);
  DVSetDefaultFunctions(ctx->itctx->vc); CHKERR(1);
  ctx->itctx->amult = SViMult;
  ctx->itctx->tamult= SViMultTrans;
  ctx->itctx->binv  = SViApplyICCPreconditioner;
  /* put dummy values in vec_sol and vec_rhs */
  ctx->itctx->vec_sol = (void *) 1;
  ctx->itctx->vec_rhs = (void *) 1;
  ctx->itctx->usr_monitor = 0;

  lctx->diag = (double *) MALLOC(n*sizeof(double)); CHKPTR(lctx->diag);
  SpGetDiagonal(ctx->mat,0,0,n-1,lctx->diag); CHKERR(1);
  for (i=0; i<n; i++) lctx->diag[i] = 1.0/sqrt(lctx->diag[i]);

  lctx->split = SpICC(ctx->mat,&lctx->failures,&lctx->alpha);  CHKERR(1);
  ctx->flops  = SpCostFactor(lctx->split) + 2*n;
  ctx->memory = SpGetSpaceUsed(lctx->split) + n*sizeof(double);
  ctx->nz     = SpNz(lctx->split);

  ctx->setupcalled = 1;
  ctx->t_setup += SYGetCPUTime() - t1;
}
