#ifndef __NLDOGLEG
#define __NLDOGLEG

typedef struct {
  void     *J;                  /* jacobian */
  void     (*GetJacobian)();
  void     (*ScaleJ)();

  void     (*JTv)(), (*Jv)();
  double   *D;                  /* Scaling for matrix */
  double   redssq;

  /* Jacobian solver */
  void     (*setupSolve)();
  void     (*solve)();
  void     (*destroySolve)();
  void     *svctx;

  /* Work space */
  int      nwork;
  void     **work;

  /* Monitor the step */
  void     (*monitor)();
} NLStepDogleg;

void NLDogLegSetup(), NLDogLeg(), NLDogLegDestroy();
void NLDogLegCreate();
void NLDogLegMonitor();

#define NLSetDogLegMonitor(a,b) \
    ((NLStepDogleg *)((a)->stepCtx))->monitor = b
#endif
