#ifndef Q_SPEC_INCLUDED
#define Q_SPEC_INCLUDED

#include "ring.h"
#include "block_types.e"


/*
** Structure of the block containing the rational field.
*/

typedef struct
	{
		t_ring_common	ring_hdr;
	}
	t_q_table;

#ifdef DEVELOP
#define m_q_str_incref(s)		(block_incref(s))
#define m_q_str_delete(s)		(q_str_delete(0,&s))
#else
#define m_q_str_incref(s)		(s)
#define m_q_str_delete(s)		/*nothing*/
#endif

/*
** Type of a rational number.
*/

#if 0
typedef t_word	rational;
#endif

/*
** Global variable declarations.
*/

extern	t_handle		q_ring;
extern	rational	Q_ONE;
extern	rational	Q_MINUS_ONE;

#ifndef Q_BLOCK_TYPE

#endif

#define q_incref(r)	((r)? block_incref(r): 0)


/*
A rational is never a small integer now:
*/
#define q_is_integer(q)	0


extern integer_big q_ceil P_((t_handle,rational));
extern integer_big q_denom_fun P_((t_handle,rational));
extern integer_big q_floor P_((t_handle,rational));
extern integer_big q_numer_fun P_((t_handle,rational));
extern integer_big q_round P_((t_handle,rational));
extern rational q_abs P_((t_handle,rational));
extern rational q_add P_((t_handle,rational,rational));
extern rational q_divide P_((t_handle,rational,rational));
extern rational q_elt_incref P_((t_handle,rational));
extern rational q_int_add P_((t_handle,rational,integer_big));
extern rational q_int_mult P_((t_handle,rational,integer_big));
extern rational q_integer_to_q P_((t_handle,integer_big));
extern rational q_inverse P_((t_handle,rational));
extern rational q_make P_((t_handle,integer_big,integer_big));
extern rational q_max P_((t_handle,rational,rational));
extern rational q_min P_((t_handle,rational,rational));
extern rational q_minus_one P_((t_handle));
extern rational q_mult P_((t_handle,rational,rational));
extern rational q_negate P_((t_handle,rational));
extern rational q_new P_((void));
extern rational q_one P_((t_handle));
extern rational q_power P_((t_handle,rational,t_int));
extern rational q_subtract P_((t_handle,rational,rational));
extern rational q_zero P_((t_handle));
extern t_bool q_eq P_((t_handle,rational,rational));
extern t_bool q_ge P_((t_handle,rational,rational));
extern t_bool q_gt P_((t_handle,rational,rational));
extern t_bool q_is_minus_one P_((t_handle,rational));
extern t_bool q_le P_((t_handle,rational,rational));
extern t_bool q_lt P_((t_handle,rational,rational));
extern t_bool q_ne P_((t_handle,rational,rational));
extern t_handle glue_q_abs P_((t_handle,t_handle));
extern t_handle glue_q_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_q_ceiling P_((t_handle,t_handle));
extern t_handle glue_q_degree P_((t_handle,t_handle));
extern t_handle glue_q_denom P_((t_handle,t_handle));
extern t_handle glue_q_eq P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle));
extern t_handle glue_q_floor P_((t_handle,t_handle));
extern t_handle glue_q_ge P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle));
extern t_handle glue_q_gt P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle));
extern t_handle glue_q_integral_basis P_((t_handle,t_handle));
extern t_handle glue_q_inverse P_((t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_q_is_minus_one P_((t_handle,t_handle));
extern t_handle glue_q_is_one P_((t_handle,t_handle));
extern t_handle glue_q_is_zero P_((t_handle,t_handle));
extern t_handle glue_q_le P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle));
extern t_handle glue_q_lt P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle));
extern t_handle glue_q_max P_((t_handle,t_handle,t_handle));
extern t_handle glue_q_min P_((t_handle,t_handle,t_handle));
extern t_handle glue_q_mult P_((t_handle,t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_q_negate P_((t_handle,t_handle,t_handle *));
extern t_handle glue_q_numer P_((t_handle,t_handle));
extern t_handle glue_q_power P_((t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle*,t_handle *));
extern t_handle glue_q_rhs_index P_((t_handle,t_handle,t_handle,t_handle*,t_handle*,t_handle *));
extern t_handle glue_q_round P_((t_handle,t_handle));
extern t_handle glue_q_sign P_((t_handle,t_handle));
extern t_handle glue_q_slash P_((t_handle,t_handle,t_handle));
extern t_handle glue_q_subtract P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle q_integral_basis P_((t_handle,t_handle));
extern t_handle q_is_one P_((t_handle,rational));
extern t_handle q_str_create P_((void));
extern t_handle q_str_incref P_((t_handle,t_handle));
extern t_int q_compare P_((t_handle,rational,rational));
extern t_int q_sign P_((t_handle,rational));
extern t_logical q_elt_coerce P_((t_handle,t_handle,t_handle,t_int,t_handle*,t_int*,t_logical));
extern t_void q_elt_delete P_((t_handle,rational *));
extern t_void q_elt_print P_((t_handle,rational));
extern t_void q_str_delete P_((t_handle,t_handle *));
extern t_void q_str_print P_((t_handle,t_handle));
extern void q_delref P_((rational));
extern void q_fix_sign P_((rational));
extern void q_simplify P_((rational));
extern void q_write P_((rational));

#endif /* Q_SPEC_INCLUDED */

