#ifndef _GEN_RING_H
#define _GEN_RING_H

typedef struct       
{
        t_pfl           is_zero;
        t_pfl           is_one;
        t_pfl           is_minus_one;
        t_pfh       elt_add;
        t_pfh       elt_subtract;
        t_pfh       elt_negate;
        t_pfh       elt_coerce;
        t_pfl       elt_equal;
        t_pfh       elt_gcd;
        t_pfh       elt_mult;
        t_pfh       elt_power;
        t_pfv       elt_delete;
        t_pfh       elt_incref;
        t_pfv       elt_print;
        t_pfh       elt_quotrem;
	t_pfh	    elt_slash;
 
} t_gring_fns;


typedef     t_gring_fns    *t_grf;
extern	    	t_gring_fns 	
		anf_gring_fns,
		order_gring_fns,
		z_gring_fns,
		q_gring_fns,
		zm_gring_fns,
		real_gring_fns,
		comp_gring_fns;
/* Defined in gen_ring/fn_tables.c */

/* This should be universally availabe */
t_grf   gen_ring_init_gprim_fns P_((t_handle));
t_void  gen_ring_biff_gprim_fns P_((t_handle));

/* Access macros */
#define m_gring_elt_add(c)     ((c).elt_add)
#define m_gring_elt_coerce(c)  ((c).elt_coerce)
#define m_gring_elt_delete(c)  ((c).elt_delete)
#define m_gring_elt_equal(c)   ((c).elt_equal)
#define m_gring_elt_gcd(c)     ((c).elt_gcd)
#define m_gring_elt_incref(c)  ((c).elt_incref)
#define m_gring_elt_mult(c)    ((c).elt_mult)
#define m_gring_elt_negate(c)  ((c).elt_negate)
#define m_gring_elt_power(c)   ((c).elt_power)
#define m_gring_elt_print(c)   ((c).elt_print)
#define m_gring_elt_quotrem(c) ((c).elt_quotrem)
#define m_gring_elt_slash(c) ((c).elt_slash)
#define m_gring_elt_subtract(c)        ((c).elt_subtract)
#define m_gring_is_zero(c)     ((c).is_zero)
#define m_gring_is_one(c)     ((c).is_one)
#define m_gring_is_minus_one(c)     ((c).is_minus_one)

/* Pointer access macros */

#define m_gringp_elt_add(c)     ((c)->elt_add)
#define m_gringp_elt_coerce(c)  ((c)->elt_coerce)
#define m_gringp_elt_delete(c)  ((c)->elt_delete)
#define m_gringp_elt_equal(c)   ((c)->elt_equal)
#define m_gringp_elt_gcd(c)     ((c)->elt_gcd)
#define m_gringp_elt_incref(c)  ((c)->elt_incref)
#define m_gringp_elt_mult(c)    ((c)->elt_mult)
#define m_gringp_elt_negate(c)  ((c)->elt_negate)
#define m_gringp_elt_power(c)   ((c)->elt_power)
#define m_gringp_elt_print(c)   ((c)->elt_print)
#define m_gringp_elt_quotrem(c) ((c)->elt_quotrem)
#define m_gringp_elt_slash(c) ((c)->elt_slash)
#define m_gringp_elt_subtract(c)        ((c)->elt_subtract)
#define m_gringp_is_zero(c)     ((c)->is_zero)
#define m_gringp_is_one(c)     ((c)->is_one)
#define m_gringp_is_minus_one(c)     ((c)->is_minus_one)

#endif /* _GEN_RING_H */
