      SUBROUTINE FLNFRE(FNR,*)
*
C     ******************************************************************
C     *                                                                *
C     *                    S U B R O U T I N E                         *
C     *                                                                *
C     *                        F L N F R E                             *
C     *                                                                *
C     ******************************************************************
C
*DOC             closes a file 
**DOC
*INDEX  FLNFRE(IN/2): Closing of a file
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       This routine closes the file with number FNR without 
**DOC       removing it.
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       FNR     (INT)   Number of file to be closed
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       -
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       IER      = 1    if this file is not allowed to be closed 
**DOC                = 2    if this file number cannot exist as a file
**DOC                = 3    if an error occured while closing the file
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       IERDEL
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       DEBUG
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS       25.07.89
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       MH       2.10.89
**DOC
*
%include 'debug.inc'
*
      INTEGER  FNR,I
*                      
      IER = 0
      DO 100 I=1,FLEDIM     
         IF(FLENRS(1,I).EQ.FNR) THEN
            IF(FLENRS(2,I).EQ.2) THEN
               IER = 1
               ERRMSG = 'FLNFRE: File is not allowed to be closed.'
            ELSE
               FLENRS(2,I) = 0                    
               IER = 3
               ERRMSG = 'FLNFRE: Error while closing file.'
               CLOSE(FNR,ERR=9999)
               CALL IERDEL()
            ENDIF     
            GOTO 9999
         ENDIF
100   CONTINUE
      IER = 2
      ERRMSG = 'FLDEL: This number not for scratch files.'
*
9999  IF(IER.EQ.0) RETURN
      RETURN 1
      END
