      BLOCK DATA BLDATA
C
C     ******************************************************************
C     *                                                                *
C     *                         B L O C K D A T A                      *
C     *                                                                *
C     *                            B L D A T A                         *
C     *                                                                *
C     ******************************************************************
*
*DOC             Block-Data subroutine for initialization
**DOC
*INDEX  BLDATA(BA/0): Block Data subroutine
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       Initialization for global variables.
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       -
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       -
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       EXFLAG = 50*0
**DOC       DNRIER = 2
**DOC       DNRINP = 5
**DOC       DNROUT = 6
**DOC       INIFLG = 0
**DOC       TSTFLG = 0
**DOC       ERRFLG = 0
**DOC       LVLPTR = 1
**DOC       DLEVEL = 1
**DOC       SUBNAM(1) = '(MAIN)'
**DOC       AIONE  = "1"  (in algebraic number fields)
**DOC       AIZERO = "0"  (in algebraic number fields)
**DOC       LONE   = "1"  (Typ LINT)
**DOC       SUBCNT (.) = 0
**DOC       SUBTIM (.) = 0
**DOC       PRMFLE = '//kant1/bsd4.2/user/kant/dat/primes.dat'
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       -
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       FIELD
**DOC       LARITH
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS       11.11.87
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       JS       07.06.88  Belegung der Primzahldatei PRMFLE
**DOC                          und von FILE01 (FORD)
**DOC       JS       12.07.88  ENDLUT auf 100 erhoeht
**DOC       JS       08.09.88  Initialization of LONE(1),LONE(2),LONE(2)
**DOC                          instead of the whole array. (cf. SYSINI)
**DOC       BA/JS    15.12.88  LONE has been zero!
**DOC       JS       01.07.89  RIEHYP <-- 0
**DOC       FS       14.07.89  OUTFLG <-- 1 
**DOC       JS       25.07.89  FLEDIM and FLENRS
**DOC       JS/MJ    14.08.89  ERRMSG
**DOC       BA/FS    27.11.89  PRECIS <-- 10,REGLBD <-- 0.D0
**DOC       JS       08.02.90  TIMSET <-- 0
**DOC       MJ/JS    12.02.90  FLDFLG
**DOC       MJ/JS    15.02.90  PURE, CYCLOT
**DOC       MH/JS    22.02.90  FLEDIM set up to 20, file numbers up to 29
**DOC       JS       02.04.90  Default = 0 for PRECIS
**DOC       JS       10.04.90  FLDNR
**DOC       JS       14.05.90  renaming of Ford-file
**DOC       FS       18.07.90  INDXMP, NAMEMP, STR1MP
**DOC       JS       30.07.90  MPITB4
**DOC       FS       01.08.90  MPINF1
**DOC       JS       09.08.90  Ford/Zassenhaus instead of Pohst/Zassenhaus
**DOC       FS       18.09.90  MPLLL1
**DOC       FS       23.11.90  LZRFLG <-- 0
**DOC       JS       07.03.91  SHLFLG,PATHes for SUN
**DOC       JS       28.05.91  LZERO
**DOC       JS       12.06.91  TSTFL1,TSTFL2, TSTSUB
**DOC
%include 'field.inc'
%include 'larith.inc'
*
*  Belegung von EXFLAG, FLDFLG, PURE, CYCLOT, FLDNR
*
      DATA      EXFLAG/50*0/
      DATA      FLDFLG, PURE, CYCLOT, FLDNR /4*0/
*
*  Belegung der DEBUG-Parameter und RIEHYP
*
      DATA      DNRIER,DNRINP,DNROUT,INIFLG,TSTFLG/6,5,6,0,0/
      DATA      TSTFL1,TSTFL2 /0,100/ 
      DATA      TSTSUB /''/
************************************************************************
*  KANT-Shell: set SHLFLG to 1 (Apollo) or 2 (Sun)                     *
*  In this case DNRIER,DNROUT and TSTFLG might be set again by SYSINI  *
*                                                                      *
      DATA      SHLFLG /0/
*                                                                      *
************************************************************************
*
      DATA      ERRFLG,LVLPTR,DLEVEL,LZRFLG/0,0,0,0/
      DATA      RIEHYP /0/ 
      DATA      OUTFLG /1/
      DATA      PRECIS /0/
      DATA      INDXMP /0/
      DATA      REGLBD /0.D0/
*
*  Belegung der Grundkonstanten 1 und 0
*
      DATA      AIONE,AIZERO /1,MAXDIM*0,MAXDIM*0,0/
*
*  Belegung der Grundkonstanten 1 und 0 (lange Arithmetik)
*
      DATA LONE(1),LONE(2),LONE(3),LZERO(1) /1,1,0,0/
*
*
*  maximale Anzahl von Unterprogrammen: 200
*
      DATA      SUBCNT,SUBTIM /200*0,200*0.0D0/
*
*     main programs
*
      DATA      NUMMP  /24/
      DATA      NAMEMP(1)  / 'MPAIN1' /
      DATA      NAMEMP(2)  / 'MPCGR1' /
      DATA      NAMEMP(3)  / 'MPCGR2' /
      DATA      NAMEMP(4)  / 'MPFAC1' /
      DATA      NAMEMP(5)  / 'MPFUN2' /
      DATA      NAMEMP(6)  / 'MPFUN4' /
      DATA      NAMEMP(7)  / 'MPISO2' / 
      DATA      NAMEMP(8)  / 'MPITB1' /
      DATA      NAMEMP(9)  / 'MPITB2' /
      DATA      NAMEMP(10) / 'MPIUN1' /
      DATA      NAMEMP(11) / 'MPIUN2' /
      DATA      NAMEMP(12) / 'MPLAT1' /
      DATA      NAMEMP(13) / 'MPNEQ1' /
      DATA      NAMEMP(14) / 'MPNRM1' /
      DATA      NAMEMP(15) / 'MPRED1' /
      DATA      NAMEMP(16) / 'MPSHV1' /
      DATA      NAMEMP(17) / 'MPSHV2' /
      DATA      NAMEMP(18) / 'MPSHV3' /
      DATA      NAMEMP(19) / 'MPTRC1' /
      DATA      NAMEMP(20) / 'MPTUN1' /
      DATA      NAMEMP(21) / 'MPITB4' /
      DATA      NAMEMP(22) / 'MPINF1' /
      DATA      NAMEMP(23) / 'MPLLL1' /
      DATA      NAMEMP(24) / 'MPIFO1' /
*
*     EXFLAG's for the main programs
*
      DATA      EXFLMP(1)  / '1000000000' /
      DATA      EXFLMP(2)  / '1000000000' /
      DATA      EXFLMP(3)  / '1000000000' /
      DATA      EXFLMP(4)  / '1000000000' /
      DATA      EXFLMP(5)  / '1000000000' /
      DATA      EXFLMP(6)  / '1120000000' /
      DATA      EXFLMP(7)  / '1000000000' /
      DATA      EXFLMP(8)  / '0000000000' /
      DATA      EXFLMP(9)  / '1000000000' /
      DATA      EXFLMP(10) / '1000000000' /
      DATA      EXFLMP(11) / '1000000000' /
      DATA      EXFLMP(12) / '0000000000' /
      DATA      EXFLMP(13) / '1100000000' /
      DATA      EXFLMP(14) / '1000000000' /
      DATA      EXFLMP(15) / '0000000000' /
      DATA      EXFLMP(16) / '0000000000' /
      DATA      EXFLMP(17) / '0000000000' /
      DATA      EXFLMP(18) / '0000000000' /
      DATA      EXFLMP(19) / '1000000000' /
      DATA      EXFLMP(20) / '1000000000' /
      DATA      EXFLMP(21) / '0000000000' /
      DATA      EXFLMP(22) / '0000000000' /
      DATA      EXFLMP(23) / '0000000000' /
      DATA      EXFLMP(24) / '1000100000' /
*
*     strings corresponding to the main programs
*
      DATA      STR1MP(1)  / 'Power product of algebraic integers' /   
      DATA      STR1MP(2)  
     * /'Computation of the ideal class group (Pohst/Zassenhaus)'/
      DATA      STR1MP(3)  
     * /'Computation of the ideal class group (Buchmann/Pohst)'/
      DATA      STR1MP(4)  
     * /'Factorization of principal ideals into prime ideals'/
      DATA      STR1MP(5)
     * /'Fundamental units for unit rank 1 or 2 (Voronoi/Buchmann)'/
      DATA      STR1MP(6)
     * /'Fundamental units if independent units are given (Pohst/Zassenh
     *aus)'/
      DATA      STR1MP(7)
     * /'Isomorphisms between number fields (Pohst)'/
      DATA      STR1MP(8)
     * /'Integral basis - Round 2 - (Ford/Zassenhaus)'/
      DATA      STR1MP(9) / 'LLL reduction of integral basis'/
      DATA      STR1MP(10)
     * /'Independent units for arbitrary unit rank (Lagrange/Buchmann)'/
      DATA      STR1MP(11) 
     * /'Independent units for arbitrary unit rank (Buchmann/Pethoe)'/
      DATA      STR1MP(12)
     * /'Generating lattices by random number generator'/
      DATA      STR1MP(13)
     * /'Norm equations in number fields (Fincke/Pohst)'/
      DATA      STR1MP(14) / 'Computing norms of algebraic integers'   /
      DATA      STR1MP(15)
     * /'Irreducibility test for integer polynomials (Kannan/Lenstra/Lov
     *asz)'/
      DATA      STR1MP(16)
     * /'Shortest vectors in lattices (Fincke/Pohst)'/
      DATA      STR1MP(17) / 'Successive minima in lattices (Jurk)'    /
      DATA      STR1MP(18)
     * /'Minkowski reduced bases in lattices (Jurk)'/
      DATA      STR1MP(19)
     * /'Trace computation of algebraic integers' /
      DATA      STR1MP(20)
     * /'Subgroup of roots of unity in a number field (Fincke/Pohst)'/
      DATA      STR1MP(21)
     * /'Integral Basis (Round 2 / Round 4) (Ford/Zassenhaus)'/
      DATA      STR1MP(22)
     * /'Field data in detail'/
      DATA      STR1MP(23)
     * /'LLL-reduction of a matrix'/
      DATA      STR1MP(24)
     * /'Index form equations in cubic number fields'/
*
*  Primzahldatei
*
C*SYS*ANF*APOLLO*
      DATA      PRMFLE
     * /'../../f/primes.dat'/
C*     * /'//kant1/bsd4.2/user/kant/dat/primes.dat'/
C*SYS*END*APOLLO*
C*SYS*ANF*SUN*
C      DATA      PRMFLE
C     * /'../prg/primes.dat'/
C*SYS*END*SUN*
C*SYS*ANF*7580-S*
C      DATA      PRMFLE
C     * /'$POHST.UTI.PRIMES'/
C*SYS*END*7580-S*
C*SYS*ANF*IBMMS*
C      DATA      PRMFLE
C     * /'PRIMES.DAT'/
C*SYS*END*IBMMS*
*
*  Ford-Daten
*
C*SYS*ANF*APOLLO*
      DATA      FILE01
     * /'//kant1/bsd4.2/user/kant/dat/f4s0i.dat'/ 
C*SYS*END*APOLLO*
C*SYS*ANF*7580-S*
C      DATA      FILE01
C     * /'$POHST.FORD1.EIN'/
C*SYS*END*7580-S*
C*SYS*ANF*SUN*
C      DATA      FILE01
C     * /'../f4s0i.dat'/
C*SYS*END*SUN*
*
*  File organization
*
*     maximal possible number of scratch files
*
      DATA      FLEDIM  /20/
*
*     default values for files
*
      DATA      ((FLENRS(I,J),I=1,2),J=1,20)
     *          /10,0,11,0,12,0,13,0,14,0,15,2,16,2,17,2,18,2,19,0,
     *           20,0,21,0,22,0,23,0,24,0,25,0,26,0,27,0,28,0,29,0/
*
*  Namenliste der Unterprogramme
*
      DATA      ENDLUT  /102/
      DATA      (SUBLUT(I),I=1,68)
     *          /'AICON ','AIDIV ','AIINV ','AIID  ','AIID2 ',
     *          'AIMAT ','AIMATL','AIMUL ','AIMULP','AINORM',
     *          'AINRML','AIPMUL','AIPMUP','AIPOT ','AIPOTP',
     *          'ANALL ','ANCON ',
     *          'BASSUP','BERLE ',
     *          'CHOLES','COMINP','COMIN1','COMIN2',
     *          'CONABS','CONLOG','CONMUL','CONNRM',
     *          'CONPMU','CONPOT',
     *          'DETI4 ','DETR8 ','DIAGMD','DISCRL','DISFAC',
     *          'ELLCNT',
     *          'FACEXP','FACI4 ','GCDINT','GCDVEC',
     *          'HERMIT','HERMSH','HERMOD','HERML ','HERMTR','IDCHPL',
     *          'IDENLA','IDFACP','IDFAC0','IDFAC1','IDFAC2','IDID2 ',
     *          'IDITB ','IDMUL ','IDORD ','IDPMUL','IDPOT ','IDRED2',
     *          'ID2CHK','ID2DIV','ID2ID ','ID2ID2','ID2INV',
     *          'ID2MUL','ID2NRM','ID2PMU','ID2POT','ID2PRM','ID2RED'/
      DATA      (SUBLUT(I),I=69,102)/
     *          'INVI4 ','INVR8',
     *          ' frei ','ITBLLL',' frei ','ITBRHO',
     *          'LCM1  ','LEQMD ','LEQR8 ','LLL   ','LLLMI4','LLLMR8',
     *          'MATQF ','MODCON','MODIV1',
     *          'NEQ   ',
     *          'NORMR ','OGOL  ','POLZR8',
     *          'PRMIND','PRMINI',
     *          'RCHOL ','REGCAL','REGLB ','REGLB1','REGLB2','REGMST',
     *          'RHOITB',
     *          'ROOTSP',
     *          'SHOVEC','SMITH ','UFDCHK',
     *          'UNITST','VCSORT'/ 
*
*  error text
*
      DATA       ERRMSG(1:16) /' (no error text)'/
*
*  Deactivating Time bound
*
      DATA       TIMSET /0/
*
      END
