#include "kant.h"
#include "thue.h" 

t_logical
thue_order_create WITH_2_ARGS(
        thue,                   th,
        t_int,                  precision
)

/*********************************************************************************

Description:
        
Calling sequence: 

History:

	92-08-24 JPS written
*********************************************************************************/
        {
	block_declarations;
        
        integer_small           deg, i, j, unit_count;
        order                   ord, ord_max;
        t_poly               	pol, old_pol;
        t_handle                Z, R; 
        anf                     field;
        matrix                  mat;
        t_logical               created;
	t_real			h1;
	t_comp			con;

        Z = m_z_str_incref(structure_z);
        deg = thue_abs_degree(th);
        m_poly_u_create_empty(&pol, deg+1);
        created = TRUE;            

        for (i=deg+1; i>0; i--)
                {   
                m_poly_coefft(pol, i-1) = thue_coeff(th, i);
                m_poly_expt(pol, i-1) = i-1;
                }
        old_pol = pol;
        pol = poly_z_clean(Z, m_poly_handle_to_poly(pol) );
        m_poly_z_delref(structure_pring_z, old_pol);
        
/*        puts("Polynom : ");
        poly_z_write(structure_pring_z, pol);
        puts("");       */

        ord = order_equation_create(Z, pol); 
        m_poly_z_delref(structure_pring_z, pol);
        order_reals_set(ord, precision);
        order_reals_create(ord);
        order_mult_table(ord);
        R = order_reals(ord);
        field = order_anf(ord); 
        
        if (!anf_poly_z_zeroes_known(field, 1) )
                {
                created = FALSE;
                }
        if (thue_print_level(th) >= 3)
                {
        	printf("Nullstellen :\n");
        	for (i=1; i<=deg; i++)
                	{
                	real_write(R, anf_poly_z_zero(field, 1, i),20);
                	puts("");
                	}
        	puts("");
                }
        
/*        puts("Maximalordnung berechnen ..."); */
        ord_max = order_maximal(ord);
        if (order_is_maximal(ord_max) )
                {
/*                if ( order_basis_is_power(ord_max) ) 
                        {
                        puts("   Order_basis_is_power !");
                        }
                if ( order_basis_is_rel(ord_max) )
                        {
                        puts("   Order_basis_is_rel !");
                        }       */
                }
        else
                {
                puts("Maximalordnung nicht gefunden!");
                created = FALSE;
                }


/*        puts("Einheiten berechnen ...");      */
        order_units_calc(ord_max);
/*        puts("Torsionseinheit berechnen ...");
        order_reg_lbound(ord_max,0,0);
        order_relation_eval_torsion_subgroup(ord_max);       
        puts("");
        puts("");                                            

        if (!order_torsion_unit_known(ord_max) )
                {
                printf("keine Torsionseinheit gefunden!\n");
                created = FALSE;
                }                                            
        printf("Torsionseinheit :\n");
        anf_elt_write(ord_max, order_torsion_unit(ord_max) ); puts("");
        printf("Rang = %d\n\n",order_torsion_rank(ord_max) );*/

        if (!order_units_are_maximal(ord_max) )
                {
                printf("nicht alle Einheiten gefunden!\n");
                created = FALSE;
                } 
        if (!order_units_are_fund(ord_max) )     
                {
                order_set_units_are_fund(ord);              /* <========== */
                created = TRUE;
                }
        unit_count = order_units_count(ord_max);
        if (thue_print_level(th) >= 3)
                {
	        printf("%d Einheiten : \n", unit_count);
        	for (i=1; i<=unit_count; i++)
                	{
                	anf_elt_write(ord_max, order_unit(ord_max, i) ); puts("");
                	}
        	puts("");
                }

        order_delete(&ord);
        order_reals_delete(ord_max);
        order_reals_set(ord_max, precision);
        order_reals_create(ord_max);    
        thue_order(th) = ord_max;
        if (thue_print_level(th) >= 4)
                {
                printf("Konjungierten der Einheiten:\n");
		for(i=1;i<=unit_count;i++)
			{
			for(j=1;j<=deg;j++)
				{
				con=anf_elt_ith_con(ord_max, order_unit(ord_max, i), j);
				h1=comp_re(R,con);
				real_write(R, h1, 20);puts("");
				real_delete(&h1);
				comp_delete(&con);
				}
			}
                mat_real_write(R, order_units_logs(ord_max));
                }
        if (thue_print_level(th) >= 2)
                {
	        order_write(ord_max);
                }
        if (order_r(ord) != deg-1)
                {
                printf("FIELD NOT TOTALLY REAL...\nNOT YET IMPLEMENTED\n\n");
                created = FALSE;
                }

        return created;
        }
