/******************************************************************************
  rel_lat_enum_create.c
******************************************************************************/
#include "kant.h"
#include "rel_lattice.h"     

rel_lat_enum_env
rel_lat_enum_create WITH_1_ARG(
	rel_lattice,	rel_lat
)
/*******************************************************************************
 
Description:	Allocating space for an enumeration environment of a relative 
		lattice
 
		The task of this routine is to allocate sufficient space 
		for the table which describes a lattice. 
 
		The invariants of the lattice are set to t_void.
 
Calling sequence:
 

 
History:
 
	92-03-11 AJ	written
 
*******************************************************************************/
{
	block_declarations;

	rel_lat_enum_env	rel_env;
        integer_small   	i, rank, number_con;
                                

	rel_env = mem_alloc_zero(sizeof(rel_lat_enum_env_struct));
	block_init(rel_env, REL_LAT_ENUM_ENV_BLOCK_TYPE);
 
        rank = rel_lat_rank(rel_lat); 
        number_con = rel_lat_number_con(rel_lat);

        rel_lat_enum_ubounds(rel_env)= MEM_NH;
 
	rel_lat_enum_request_set_next(rel_env);
 
	rel_lat_enum_status_set_new(rel_env);

	rel_lat_enum_level_flag(rel_env)= MEM_NH;
	rel_lat_enum_termination_flag(rel_env)= MEM_NH;
					
	rel_lat_enum_act_coefs(rel_env)= MEM_NH;
	rel_lat_enum_act_coefs_con(rel_env)= MEM_NH;
  	rel_lat_enum_act_lengths(rel_env)=  MEM_NH;

        rel_lat_enum_tmp_bounds(rel_env)= MEM_NH;
                                                        
        rel_lat_enum_part_sums(rel_env)= MEM_NH;

        rel_lat_enum_coefs_lat(rel_env)= MEM_NH;
        rel_lat_enum_coefs_env(rel_env)= MEM_NH;


	return rel_env;
}
