#include "kant.h" 
#include "anf_rel_sort.h" 


t_logical
rel_anf_ceiling_fincke_next_sub  WITH_6_ARGS( 
	vector,		 ubounds_con,
	vector,		 lbounds_con,
	vector *,	 rvec_con,
	integer_small, 	 sj,
	integer_small,	 tj,
	integer_small *, modi
)
/*******************************************************************************
 
Description:
 
	The function returns the next vector for  one conjugated field
	for the relative ellipsoid method.

 
Calling sequence:
 
	log= rel_anf_ceiling_fincke_next(sort, ubouns_con, lbounds_con, &rvec_con
			                 sj, tj, &modi);
 
	vector		ubounds_con  = a vector with the bounds vor one conj. field
	vector		lbounds_con  = a vector with the bounds vor one conj. field
      	vector          rvec         = t_handle of an vector for the exponents of the 
			               lambda over one conjugated field
	integer_small	sj	     = -1, if sj and tj not exist
				       sj,  else
	integer_small	tj	     = -1, if sj and tj not exist
				       tj,  else
	integer_small   modi         = 1, if rvec must be initialized
				       0, else
	t_logical		log	     = 1, if there is a next vector
                                       0, if there is no next vector			
 
History:
 
	92-07-02 AJ    written
 
*******************************************************************************/
{  
	block_declarations;

	integer_small	i, j, m, sum, neqnum, h1, h2, lev, test;

          
/*** Initialisation  **********************************************************/

	m= vec_length(ubounds_con);


/*** Enumeration of the next vector ******************************************/

	lev= 1;                       
	sum= 0; 

/*** Initialisation **********************************************************/

	if (*modi==1)
	 {
	  *modi=0;
	  for (i=1; i<=m; i++)
	   {
	    if (vec_entry(ubounds_con,i)>=0)
	     {
	      if (vec_entry(lbounds_con,i)>=0)
	        vec_entry(*rvec_con,i)= vec_entry(lbounds_con,i);
	       else
	        vec_entry(*rvec_con,i)= 0;
	     }
	    else
              vec_entry(*rvec_con,i)= vec_entry(ubounds_con,i);
	   }

	  for (i=1; i<=m; i++)
           sum= sum + vec_entry(*rvec_con,i);

	  if (sum==0)
           {
	    if (sj>=0)
	      {
	       neqnum= 0;  
	       test= 1;
	       for (j= sj+1; j<=sj+tj; j++)
	        {
	 	 if ( ((vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j))<0) ||
	              ((vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j))>1)  )  
	          {
	   	   test= 0;
		   break;
		  }
	         if ( (vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j)) != 0 )
 	           neqnum= neqnum+1;
		 if (neqnum>1)  break;
	        }
	       if ( (neqnum<=1) && (test) )   return 1;
	      }
	     else
	      return 1;
	   }
	 }
/*
        printf("\n\nfincke_next: after initialisation  ");
	for (i=1; i<=m; i++)
	  printf(" %d  ", vec_entry(*rvec_con,i));
        printf(" ,   sum= %d  ", sum);
  	printf("\n \n");
*/

/*** New rvec_con ****************************************************************/

        while (lev<=m)
	 {  
/*
          printf("\n\nfincke_next: top of the while loop  ");
	  for (i=1; i<=m; i++)
	    printf(" %d  ", vec_entry(*rvec_con,i));
	    printf(" ,   sum= %d  ", sum);
    	  printf("\n \n");
*/
	  if (vec_entry(*rvec_con,lev) > 0)
	   {
	    sum= sum - 2*vec_entry(*rvec_con,lev);  
	    vec_entry(*rvec_con,lev) = -vec_entry(*rvec_con,lev);

	    if ( (vec_entry(*rvec_con,lev)>= vec_entry(lbounds_con,lev))
	          &&(sum==0) ) 
	     { 
	      if (sj>=0)
	       {
	        neqnum= 0;
	 	test= 1;
	        for (j= sj+1; j<=sj+tj; j++)
	         {
	  	  if ( ((vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j))<0) ||
	               ((vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j))>1)  )  
	           {  
		    test= 0;
	 	    break;
		   }
	          if ( (vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j)) != 0 )
 	            neqnum= neqnum+1;
		  if (neqnum>1)  break;
	         }
	        if ( (neqnum<=1) && (test) )   return 1;
	       }
	      else
	       return 1;
	     }

             
	    if (  vec_entry(*rvec_con,lev)>=  vec_entry(lbounds_con,lev))
	     {
	      lev= 1;
	      continue;           
	     }
 
	    sum= sum - 2* vec_entry(*rvec_con,lev) + 1; 
	    vec_entry(*rvec_con,lev) = -vec_entry(*rvec_con,lev) + 1;	

	    if ( (vec_entry(*rvec_con,lev)<= vec_entry(ubounds_con,lev))
	          &&(sum==0) ) 
	     {
	      if (sj>=0)
	       {
	        neqnum= 0; 
		test= 1;
	        for (j= sj+1; j<=sj+tj; j++)
	         {
	  	  if ( ((vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j))<0) ||
	               ((vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j))>1)  )  
	           {    
	 	    test= 0;
		    break;
		   }
	          if ( (vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j)) != 0 )
 	            neqnum= neqnum+1;
		  if (neqnum>1)  break;
	         }
	        if ( (neqnum<=1) && (test) )   return 1;
	       }
	      else
	       return 1;
	     }

	    if (  vec_entry(*rvec_con,lev)<= vec_entry(ubounds_con,lev)  )
	     {
	      lev= 1;
	      continue;
	     }
	   }
	  else
	   {
	    sum= sum - 2* vec_entry(*rvec_con,lev) + 1; 
	    vec_entry(*rvec_con,lev) = -vec_entry(*rvec_con,lev) + 1;	

	    if ( (vec_entry(*rvec_con,lev)<=  vec_entry(ubounds_con,lev))
	          &&(sum==0) ) 
	     {
	      if (sj>=0)
	       {
	        neqnum= 0;
		test= 1;
	        for (j= sj+1; j<=sj+tj; j++)
	         {
	  	  if ( ((vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j))<0) ||
	               ((vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j))>1)  )  
	           {
		    test= 0;
	 	    break;
		   }
	          if ( (vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j)) != 0 )
 	            neqnum= neqnum+1;
		  if (neqnum>1)  break;
	         }
	        if ( (neqnum<=1) && (test) )   return 1;
	       }
	      else
	       return 1;
	     }

	    if (  vec_entry(*rvec_con,lev)<= vec_entry(ubounds_con,lev)  )
	     {
	      lev= 1;
	      continue;
	     }

	    sum= sum - 2*vec_entry(*rvec_con,lev);
	    vec_entry(*rvec_con,lev) = -vec_entry(*rvec_con,lev);

	    if ( (vec_entry(*rvec_con,lev)>= vec_entry(lbounds_con,lev))
	          &&(sum==0) ) 
	     {
	      if (sj>=0)
	       {
	        neqnum= 0;
		test= 1;
	        for (j= sj+1; j<=sj+tj; j++)
	         {
	  	  if ( ((vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j))<0) ||
	               ((vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j))>1)  )  
	           {
 	            test= 0;
		    break;
		   }
	          if ( (vec_entry(*rvec_con,j+tj)-vec_entry(*rvec_con,j)) != 0 )
 	            neqnum= neqnum+1;
		  if (neqnum>1)  break;
	         }
	        if ( (neqnum<=1) && (test) )   return 1;
	       }
	      else
	       return 1;
	     }
            
	    if (  vec_entry(*rvec_con,lev)>= vec_entry(lbounds_con,lev) )
	     {
	      lev= 1;
	      continue;
	     }
	   }
          
	  if (vec_entry(ubounds_con,lev)>=0)
	   {
	    if (vec_entry(lbounds_con,lev)>=0)
	      vec_entry(*rvec_con,lev)= vec_entry(lbounds_con,lev);
	     else
	      vec_entry(*rvec_con,lev)= 0;
	   }
	  else
            vec_entry(*rvec_con,lev)= vec_entry(ubounds_con,lev);

	  sum= 0;
	  for (i=1; i<=m; i++)
           sum= sum + vec_entry(*rvec_con,i);

          lev= lev+1;
         }
              
/*** No vector found **********************************************************/

	return 0;

} 

