#include "kant.h" 


t_real
hermite_constant  WITH_2_ARGS( 
        t_handle,		R,
	integer_big,	n
)
/*******************************************************************************
 
Description:
 
	This routine computes the Hermite constants for N<9 and              
	upper estimates for the Hermite constants for N>8 using              
	the Blichfeldt estimations.                                          
	Reference:                                                           
	M. Pohst and H. Zassenhaus, Algorithmic Algebraic Number Theory,     
	Cambridge Univ. Press, New York 1989.                                
                                                                     

 
Calling sequence:
 
	const1= hermit_constant(n);
                          
	t_handle		R
	integer_big	n
	t_real		const1

 
History:
 
	92-07-14 AJ    written
 
*******************************************************************************/
{  
	block_declarations;
                              
	t_real		const1, temp1, temp2, temp3, temp4;

	switch (n)
	{
	case 1	: 	const1= conv_int_to_real(R, 1);
			break;
	case 2	: 	const1= conv_double_to_real(R, 4.0/3.0);
			break;
	case 3	: 	const1= conv_int_to_real(R, 2);
			break;
	case 4	: 	const1= conv_int_to_real(R, 4);
			break;
	case 5	: 	const1= conv_int_to_real(R, 8);
			break;
	case 6	: 	const1= conv_double_to_real(R, 64.0/3.0);
			break;
	case 7	: 	const1= conv_int_to_real(R, 64);
			break;
	case 8	: 	const1= conv_int_to_real(R, 256);
			break;

	default	: 	if (n<1)
		          error_internal("hermite_constant: n<1\n");
		   	 else
			  {                     
                           temp1= conv_double_to_real(R, 1.0+(n+2.0)/2.0);
			   temp2= real_gamma(R, temp1);
			   real_delete(&temp1);
			   temp1= real_mult(R, temp2, temp2);
			   real_delete(&temp2);

			   temp2= real_pi(R);
			   temp3= conv_int_to_real(R, 2);
			   temp4= real_divide(R, temp3, temp2);
			   real_delete(&temp2);
			   real_delete(&temp3);
			   temp2= real_power(R, temp4, n);
			   real_delete(&temp4);

		           const1= real_mult(R, temp2, temp1);
			   real_delete(&temp2);
			   real_delete(&temp1);
			  }
	}

	return const1;
} 

