#include "defs.h"
#include "integer.e"
#include "zm.e"
#include "error.e"

public t_handle
v3glue_zm_slash_op(s, e1, e2)
t_handle s, e1, e2;
{ 
	t_integer mod = zm_modulus(s);
	return modint_div(mod, e1, e2 );
}
public t_handle
v3glue_zm_inv(s, e1)
t_handle s, e1;
{ 
	return zm_inverse(s, e1 );
}
public t_handle
v3glue_zm_add(s, e1, e2)
t_handle s, e1, e2;
{ 
	t_integer mod = zm_modulus(s);
	return modint_add(mod, e1, e2 );
}

public t_handle
v3glue_zm_eq(s, e1,e2) 
t_handle s, e1, e2;
{ 
	return integer_eq( e1, e2 ) ;
}

public t_handle
v3glue_zm_is_minus_one(str, elt)
t_handle str, elt;
{ 
	return zm_is_minus_one(str, elt);
}

public t_handle
v3glue_zm_is_one(str, elt)
t_handle str, elt;
{ 
	return (elt == 1);
}
public t_handle
v3glue_zm_is_zero(str, elt)
t_handle str, elt;
{ 
	return( elt == 0 );
}

public t_handle
v3glue_zm_mult (str, e1, e2)
t_handle str, e1, e2;
{ 
	t_integer mod = zm_modulus(str);
	return modint_mult(mod, e1, e2 );
}

public t_handle
v3glue_zm_negate(s, e)
t_handle s, e;
{ 
	t_integer mod = zm_modulus(s);
	return modint_negate(mod, e );
}


public t_handle
v3glue_zm_power(s, e1, n)
t_handle s, e1, n;
{ 
	t_integer mod = zm_modulus(s);
	return modint_exp(mod,  e1, n );
}

public t_handle
v3glue_zm_subtract(s, e1, e2)
t_handle s, e1, e2;
{ 
	t_integer mod = zm_modulus(s);
	return modint_subtract(mod,  e1, e2 );
}

