
#include "defs.h"
#include "real.e"

t_handle
glue_real_mult WITH_7_ARGS(
        t_handle,       ring,
        integer_big,    a,
        t_int,          it1,
        integer_big,    b,
        t_int,          it2,
        integer_big *,  res,
        t_int *,        it3
)
{
	*res = real_mult(ring,a,b);
	*it3 = 0;
}



public t_logical glue_real_eq (s1, e1, it1, s2, e2, it2)
t_handle s1, e1, s2, e2;
t_int it1, it2;
{
	return real_eq(s1, e1, e2);
}

public t_logical glue_real_gt (s1, e1, it1, s2, e2, it2)
t_handle s1, e1, s2, e2;
t_int it1, it2;
{
	return real_gt(s1, e1, e2);
}

public t_logical glue_real_ge (s1, e1, it1, s2, e2, it2, res_e)
t_handle s1, e1, s2, e2, *res_e;
t_int it1, it2;
{
	return real_ge(s1, e1, e2);
}

public t_logical glue_real_lt (s1, e1, it1, s2, e2, it2, res_e)
t_handle s1, e1, s2, e2, *res_e;
t_int it1, it2;
{
	 return real_lt(s1, e1, e2);
}

public t_logical glue_real_le (s1, e1, it1, s2, e2, it2, res_e)
t_handle s1, e1, s2, e2, *res_e;
t_int it1, it2;
{
	return real_le(s1, e1, e2);
}


public t_handle
glue_real_add(s1, e1, e2, res_e)
t_handle s1, e1, e2, *res_e;
{
	*res_e = real_add(s1, e1, e2);
}

public t_handle
glue_real_subtract(s1, e1, e2, res_e)
t_handle s1, e1, e2, *res_e;
{
	*res_e = real_subtract(s1, e1, e2);
}

public t_handle
glue_real_negate(s, e, res_e)
t_handle s, e, *res_e;
{
	*res_e = real_negate(s, e);
}

public t_handle
glue_real_log(s, e, res_s, res_e)
t_handle s, e, *res_s, *res_e;
{
	*res_e = real_log(s, e);
	*res_s = m_real_str_incref(s);
}

public t_handle
glue_real_norm(s1, e1, res_s, res_e)
t_handle s1, e1, *res_e, *res_s;
{
	*res_e = real_abs(s1, e1);
	*res_s = m_real_str_incref(s1);
}

public t_handle
glue_real_power(s1, e1, it1, n, res_s, res_e, res_it)
t_handle s1, e1, it1, n, *res_s, *res_e, *res_it;
{
	*res_e = real_power(s1, e1, n);
	*res_s = m_real_str_incref(s1);
}

public t_handle
glue_real_slash(s1, e1, e2)
t_handle s1, e1, e2;
{
	return real_divide(s1, e1, e2);
}

public t_handle
glue_real_is_one(str, elt)
t_handle str, elt;
{
    mp_float	f;

    real_make_mp(elt, f);
    return mp_cmp_int(f, 1) == 0;
}

public t_handle
glue_real_is_zero(str, elt)
t_handle str, elt;
{
    mp_float	f;

    real_make_mp(elt, f);
    return mp_cmp_int(f, 0) == 0;
}

public t_handle
glue_real_is_minus_one(str, elt)
t_handle str, elt;
{
    mp_float	f;

    real_make_mp(elt, f);
    return mp_cmp_int(f, -1) == 0;
}

public t_handle
glue_real_inverse(str, elt, it, res_elt, res_it)
t_handle str, elt, it, *res_elt, *res_it;
{
    *res_it = 0;
    *res_elt = real_inverse(str, elt);
}
